@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.datasync.kotlin

import com.pulumi.aws.datasync.S3LocationArgs.builder
import com.pulumi.aws.datasync.kotlin.inputs.S3LocationS3ConfigArgs
import com.pulumi.aws.datasync.kotlin.inputs.S3LocationS3ConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages an S3 Location within AWS DataSync.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.datasync.S3Location;
 * import com.pulumi.aws.datasync.S3LocationArgs;
 * import com.pulumi.aws.datasync.inputs.S3LocationS3ConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new S3Location("example", S3LocationArgs.builder()
 *             .s3BucketArn(aws_s3_bucket.example().arn())
 *             .subdirectory("/example/prefix")
 *             .s3Config(S3LocationS3ConfigArgs.builder()
 *                 .bucketAccessRoleArn(aws_iam_role.example().arn())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_datasync_location_s3` using the DataSync Task Amazon Resource Name (ARN). For example:
 * ```sh
 *  $ pulumi import aws:datasync/s3Location:S3Location example arn:aws:datasync:us-east-1:123456789012:location/loc-12345678901234567
 * ```
 * @property agentArns A list of DataSync Agent ARNs with which this location will be associated.
 * @property s3BucketArn Amazon Resource Name (ARN) of the S3 Bucket.
 * @property s3Config Configuration block containing information for connecting to S3.
 * @property s3StorageClass The Amazon S3 storage class that you want to store your files in when this location is used as a task destination. [Valid values](https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#using-storage-classes)
 * @property subdirectory Prefix to perform actions as source or destination.
 * @property tags Key-value pairs of resource tags to assign to the DataSync Location. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class S3LocationArgs(
    public val agentArns: Output<List<String>>? = null,
    public val s3BucketArn: Output<String>? = null,
    public val s3Config: Output<S3LocationS3ConfigArgs>? = null,
    public val s3StorageClass: Output<String>? = null,
    public val subdirectory: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.datasync.S3LocationArgs> {
    override fun toJava(): com.pulumi.aws.datasync.S3LocationArgs =
        com.pulumi.aws.datasync.S3LocationArgs.builder()
            .agentArns(agentArns?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .s3BucketArn(s3BucketArn?.applyValue({ args0 -> args0 }))
            .s3Config(s3Config?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .s3StorageClass(s3StorageClass?.applyValue({ args0 -> args0 }))
            .subdirectory(subdirectory?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [S3LocationArgs].
 */
@PulumiTagMarker
public class S3LocationArgsBuilder internal constructor() {
    private var agentArns: Output<List<String>>? = null

    private var s3BucketArn: Output<String>? = null

    private var s3Config: Output<S3LocationS3ConfigArgs>? = null

    private var s3StorageClass: Output<String>? = null

    private var subdirectory: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value A list of DataSync Agent ARNs with which this location will be associated.
     */
    @JvmName("rcigbdsveltxkcas")
    public suspend fun agentArns(`value`: Output<List<String>>) {
        this.agentArns = value
    }

    @JvmName("lgmxfphroorfydgq")
    public suspend fun agentArns(vararg values: Output<String>) {
        this.agentArns = Output.all(values.asList())
    }

    /**
     * @param values A list of DataSync Agent ARNs with which this location will be associated.
     */
    @JvmName("buybgwssvwpjeknx")
    public suspend fun agentArns(values: List<Output<String>>) {
        this.agentArns = Output.all(values)
    }

    /**
     * @param value Amazon Resource Name (ARN) of the S3 Bucket.
     */
    @JvmName("jmwgeypkgnehrkas")
    public suspend fun s3BucketArn(`value`: Output<String>) {
        this.s3BucketArn = value
    }

    /**
     * @param value Configuration block containing information for connecting to S3.
     */
    @JvmName("fqfhfwiwmablymlu")
    public suspend fun s3Config(`value`: Output<S3LocationS3ConfigArgs>) {
        this.s3Config = value
    }

    /**
     * @param value The Amazon S3 storage class that you want to store your files in when this location is used as a task destination. [Valid values](https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#using-storage-classes)
     */
    @JvmName("wuxvqaehyasgmdlm")
    public suspend fun s3StorageClass(`value`: Output<String>) {
        this.s3StorageClass = value
    }

    /**
     * @param value Prefix to perform actions as source or destination.
     */
    @JvmName("wuwtcgbfdiupnxho")
    public suspend fun subdirectory(`value`: Output<String>) {
        this.subdirectory = value
    }

    /**
     * @param value Key-value pairs of resource tags to assign to the DataSync Location. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ixxjhdalriqecbsy")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value A list of DataSync Agent ARNs with which this location will be associated.
     */
    @JvmName("dbmauhmmsjgsedst")
    public suspend fun agentArns(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.agentArns = mapped
    }

    /**
     * @param values A list of DataSync Agent ARNs with which this location will be associated.
     */
    @JvmName("vjfspjcgemltlmvq")
    public suspend fun agentArns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.agentArns = mapped
    }

    /**
     * @param value Amazon Resource Name (ARN) of the S3 Bucket.
     */
    @JvmName("jotepqxipxcqwcmv")
    public suspend fun s3BucketArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3BucketArn = mapped
    }

    /**
     * @param value Configuration block containing information for connecting to S3.
     */
    @JvmName("vhufvrixmslwyiyc")
    public suspend fun s3Config(`value`: S3LocationS3ConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3Config = mapped
    }

    /**
     * @param argument Configuration block containing information for connecting to S3.
     */
    @JvmName("btmgrhfpfcyxjapg")
    public suspend fun s3Config(argument: suspend S3LocationS3ConfigArgsBuilder.() -> Unit) {
        val toBeMapped = S3LocationS3ConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.s3Config = mapped
    }

    /**
     * @param value The Amazon S3 storage class that you want to store your files in when this location is used as a task destination. [Valid values](https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#using-storage-classes)
     */
    @JvmName("ilaqbttweqkwphwx")
    public suspend fun s3StorageClass(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3StorageClass = mapped
    }

    /**
     * @param value Prefix to perform actions as source or destination.
     */
    @JvmName("ljkhuwyelbosxjsy")
    public suspend fun subdirectory(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subdirectory = mapped
    }

    /**
     * @param value Key-value pairs of resource tags to assign to the DataSync Location. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("nxcpoamhigelylwu")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value pairs of resource tags to assign to the DataSync Location. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("uqatyruuurxxojyi")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): S3LocationArgs = S3LocationArgs(
        agentArns = agentArns,
        s3BucketArn = s3BucketArn,
        s3Config = s3Config,
        s3StorageClass = s3StorageClass,
        subdirectory = subdirectory,
        tags = tags,
    )
}
