@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.datasync.kotlin

import com.pulumi.aws.datasync.TaskArgs.builder
import com.pulumi.aws.datasync.kotlin.inputs.TaskExcludesArgs
import com.pulumi.aws.datasync.kotlin.inputs.TaskExcludesArgsBuilder
import com.pulumi.aws.datasync.kotlin.inputs.TaskIncludesArgs
import com.pulumi.aws.datasync.kotlin.inputs.TaskIncludesArgsBuilder
import com.pulumi.aws.datasync.kotlin.inputs.TaskOptionsArgs
import com.pulumi.aws.datasync.kotlin.inputs.TaskOptionsArgsBuilder
import com.pulumi.aws.datasync.kotlin.inputs.TaskScheduleArgs
import com.pulumi.aws.datasync.kotlin.inputs.TaskScheduleArgsBuilder
import com.pulumi.aws.datasync.kotlin.inputs.TaskTaskReportConfigArgs
import com.pulumi.aws.datasync.kotlin.inputs.TaskTaskReportConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages an AWS DataSync Task, which represents a configuration for synchronization. Starting an execution of these DataSync Tasks (actually synchronizing files) is performed outside of this resource.
 * ## Example Usage
 * ### With Scheduling
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.datasync.Task;
 * import com.pulumi.aws.datasync.TaskArgs;
 * import com.pulumi.aws.datasync.inputs.TaskScheduleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Task("example", TaskArgs.builder()
 *             .destinationLocationArn(aws_datasync_location_s3.destination().arn())
 *             .sourceLocationArn(aws_datasync_location_nfs.source().arn())
 *             .schedule(TaskScheduleArgs.builder()
 *                 .scheduleExpression("cron(0 12 ? * SUN,WED *)")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### With Filtering
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.datasync.Task;
 * import com.pulumi.aws.datasync.TaskArgs;
 * import com.pulumi.aws.datasync.inputs.TaskExcludesArgs;
 * import com.pulumi.aws.datasync.inputs.TaskIncludesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Task("example", TaskArgs.builder()
 *             .destinationLocationArn(aws_datasync_location_s3.destination().arn())
 *             .sourceLocationArn(aws_datasync_location_nfs.source().arn())
 *             .excludes(TaskExcludesArgs.builder()
 *                 .filterType("SIMPLE_PATTERN")
 *                 .value("/folder1|/folder2")
 *                 .build())
 *             .includes(TaskIncludesArgs.builder()
 *                 .filterType("SIMPLE_PATTERN")
 *                 .value("/folder1|/folder2")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_datasync_task` using the DataSync Task Amazon Resource Name (ARN). For example:
 * ```sh
 *  $ pulumi import aws:datasync/task:Task example arn:aws:datasync:us-east-1:123456789012:task/task-12345678901234567
 * ```
 * @property cloudwatchLogGroupArn Amazon Resource Name (ARN) of the CloudWatch Log Group that is used to monitor and log events in the sync task.
 * @property destinationLocationArn Amazon Resource Name (ARN) of destination DataSync Location.
 * @property excludes Filter rules that determines which files to exclude from a task.
 * @property includes Filter rules that determines which files to include in a task.
 * @property name Name of the DataSync Task.
 * @property options Configuration block containing option that controls the default behavior when you start an execution of this DataSync Task. For each individual task execution, you can override these options by specifying an overriding configuration in those executions.
 * @property schedule Specifies a schedule used to periodically transfer files from a source to a destination location.
 * @property sourceLocationArn Amazon Resource Name (ARN) of source DataSync Location.
 * @property tags Key-value pairs of resource tags to assign to the DataSync Task. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property taskReportConfig Configuration block containing the configuration of a DataSync Task Report. See `task_report_config` below.
 */
public data class TaskArgs(
    public val cloudwatchLogGroupArn: Output<String>? = null,
    public val destinationLocationArn: Output<String>? = null,
    public val excludes: Output<TaskExcludesArgs>? = null,
    public val includes: Output<TaskIncludesArgs>? = null,
    public val name: Output<String>? = null,
    public val options: Output<TaskOptionsArgs>? = null,
    public val schedule: Output<TaskScheduleArgs>? = null,
    public val sourceLocationArn: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val taskReportConfig: Output<TaskTaskReportConfigArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.datasync.TaskArgs> {
    override fun toJava(): com.pulumi.aws.datasync.TaskArgs =
        com.pulumi.aws.datasync.TaskArgs.builder()
            .cloudwatchLogGroupArn(cloudwatchLogGroupArn?.applyValue({ args0 -> args0 }))
            .destinationLocationArn(destinationLocationArn?.applyValue({ args0 -> args0 }))
            .excludes(excludes?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .includes(includes?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .options(options?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .schedule(schedule?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sourceLocationArn(sourceLocationArn?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .taskReportConfig(
                taskReportConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [TaskArgs].
 */
@PulumiTagMarker
public class TaskArgsBuilder internal constructor() {
    private var cloudwatchLogGroupArn: Output<String>? = null

    private var destinationLocationArn: Output<String>? = null

    private var excludes: Output<TaskExcludesArgs>? = null

    private var includes: Output<TaskIncludesArgs>? = null

    private var name: Output<String>? = null

    private var options: Output<TaskOptionsArgs>? = null

    private var schedule: Output<TaskScheduleArgs>? = null

    private var sourceLocationArn: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var taskReportConfig: Output<TaskTaskReportConfigArgs>? = null

    /**
     * @param value Amazon Resource Name (ARN) of the CloudWatch Log Group that is used to monitor and log events in the sync task.
     */
    @JvmName("wktricwyupmuonas")
    public suspend fun cloudwatchLogGroupArn(`value`: Output<String>) {
        this.cloudwatchLogGroupArn = value
    }

    /**
     * @param value Amazon Resource Name (ARN) of destination DataSync Location.
     */
    @JvmName("emhtkbmnuxbjsaba")
    public suspend fun destinationLocationArn(`value`: Output<String>) {
        this.destinationLocationArn = value
    }

    /**
     * @param value Filter rules that determines which files to exclude from a task.
     */
    @JvmName("drimjlotktardcuc")
    public suspend fun excludes(`value`: Output<TaskExcludesArgs>) {
        this.excludes = value
    }

    /**
     * @param value Filter rules that determines which files to include in a task.
     */
    @JvmName("deuifhglpeamcbpd")
    public suspend fun includes(`value`: Output<TaskIncludesArgs>) {
        this.includes = value
    }

    /**
     * @param value Name of the DataSync Task.
     */
    @JvmName("qkinrankpbaygkbr")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Configuration block containing option that controls the default behavior when you start an execution of this DataSync Task. For each individual task execution, you can override these options by specifying an overriding configuration in those executions.
     */
    @JvmName("ngjuvsymnijbgoqd")
    public suspend fun options(`value`: Output<TaskOptionsArgs>) {
        this.options = value
    }

    /**
     * @param value Specifies a schedule used to periodically transfer files from a source to a destination location.
     */
    @JvmName("nhvatlispdgqvxdm")
    public suspend fun schedule(`value`: Output<TaskScheduleArgs>) {
        this.schedule = value
    }

    /**
     * @param value Amazon Resource Name (ARN) of source DataSync Location.
     */
    @JvmName("ypfpvtylpkuqfmov")
    public suspend fun sourceLocationArn(`value`: Output<String>) {
        this.sourceLocationArn = value
    }

    /**
     * @param value Key-value pairs of resource tags to assign to the DataSync Task. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("divfdovqprekwkuo")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Configuration block containing the configuration of a DataSync Task Report. See `task_report_config` below.
     */
    @JvmName("yavgksamivsoimrr")
    public suspend fun taskReportConfig(`value`: Output<TaskTaskReportConfigArgs>) {
        this.taskReportConfig = value
    }

    /**
     * @param value Amazon Resource Name (ARN) of the CloudWatch Log Group that is used to monitor and log events in the sync task.
     */
    @JvmName("lrhslcnohomxxedg")
    public suspend fun cloudwatchLogGroupArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudwatchLogGroupArn = mapped
    }

    /**
     * @param value Amazon Resource Name (ARN) of destination DataSync Location.
     */
    @JvmName("eehvithmyqqjofva")
    public suspend fun destinationLocationArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationLocationArn = mapped
    }

    /**
     * @param value Filter rules that determines which files to exclude from a task.
     */
    @JvmName("mumvasmmlbdpmssj")
    public suspend fun excludes(`value`: TaskExcludesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.excludes = mapped
    }

    /**
     * @param argument Filter rules that determines which files to exclude from a task.
     */
    @JvmName("jwccgvtcangfkbmu")
    public suspend fun excludes(argument: suspend TaskExcludesArgsBuilder.() -> Unit) {
        val toBeMapped = TaskExcludesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.excludes = mapped
    }

    /**
     * @param value Filter rules that determines which files to include in a task.
     */
    @JvmName("bwbgglljknnmefbw")
    public suspend fun includes(`value`: TaskIncludesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.includes = mapped
    }

    /**
     * @param argument Filter rules that determines which files to include in a task.
     */
    @JvmName("ifcvryyragejejmp")
    public suspend fun includes(argument: suspend TaskIncludesArgsBuilder.() -> Unit) {
        val toBeMapped = TaskIncludesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.includes = mapped
    }

    /**
     * @param value Name of the DataSync Task.
     */
    @JvmName("ofdcbnhgpkvlgwog")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Configuration block containing option that controls the default behavior when you start an execution of this DataSync Task. For each individual task execution, you can override these options by specifying an overriding configuration in those executions.
     */
    @JvmName("fhpcboipnthnfyes")
    public suspend fun options(`value`: TaskOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.options = mapped
    }

    /**
     * @param argument Configuration block containing option that controls the default behavior when you start an execution of this DataSync Task. For each individual task execution, you can override these options by specifying an overriding configuration in those executions.
     */
    @JvmName("qcjmampvvwohvqlt")
    public suspend fun options(argument: suspend TaskOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = TaskOptionsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.options = mapped
    }

    /**
     * @param value Specifies a schedule used to periodically transfer files from a source to a destination location.
     */
    @JvmName("jqpigfqcupdnbmmn")
    public suspend fun schedule(`value`: TaskScheduleArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schedule = mapped
    }

    /**
     * @param argument Specifies a schedule used to periodically transfer files from a source to a destination location.
     */
    @JvmName("nobmrkhpnvjdirsq")
    public suspend fun schedule(argument: suspend TaskScheduleArgsBuilder.() -> Unit) {
        val toBeMapped = TaskScheduleArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.schedule = mapped
    }

    /**
     * @param value Amazon Resource Name (ARN) of source DataSync Location.
     */
    @JvmName("oleprcfchoksogat")
    public suspend fun sourceLocationArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceLocationArn = mapped
    }

    /**
     * @param value Key-value pairs of resource tags to assign to the DataSync Task. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("bpvchbopdunveini")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value pairs of resource tags to assign to the DataSync Task. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("epuxxlcanynkjpay")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Configuration block containing the configuration of a DataSync Task Report. See `task_report_config` below.
     */
    @JvmName("aisjklkgblfwoqrn")
    public suspend fun taskReportConfig(`value`: TaskTaskReportConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.taskReportConfig = mapped
    }

    /**
     * @param argument Configuration block containing the configuration of a DataSync Task Report. See `task_report_config` below.
     */
    @JvmName("sfiasivimfinsejh")
    public suspend
    fun taskReportConfig(argument: suspend TaskTaskReportConfigArgsBuilder.() -> Unit) {
        val toBeMapped = TaskTaskReportConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.taskReportConfig = mapped
    }

    internal fun build(): TaskArgs = TaskArgs(
        cloudwatchLogGroupArn = cloudwatchLogGroupArn,
        destinationLocationArn = destinationLocationArn,
        excludes = excludes,
        includes = includes,
        name = name,
        options = options,
        schedule = schedule,
        sourceLocationArn = sourceLocationArn,
        tags = tags,
        taskReportConfig = taskReportConfig,
    )
}
