@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.datasync.kotlin.inputs

import com.pulumi.aws.datasync.inputs.EfsLocationEc2ConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property securityGroupArns List of Amazon Resource Names (ARNs) of the EC2 Security Groups that are associated with the EFS Mount Target.
 * @property subnetArn Amazon Resource Name (ARN) of the EC2 Subnet that is associated with the EFS Mount Target.
 */
public data class EfsLocationEc2ConfigArgs(
    public val securityGroupArns: Output<List<String>>,
    public val subnetArn: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.datasync.inputs.EfsLocationEc2ConfigArgs> {
    override fun toJava(): com.pulumi.aws.datasync.inputs.EfsLocationEc2ConfigArgs =
        com.pulumi.aws.datasync.inputs.EfsLocationEc2ConfigArgs.builder()
            .securityGroupArns(securityGroupArns.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .subnetArn(subnetArn.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EfsLocationEc2ConfigArgs].
 */
@PulumiTagMarker
public class EfsLocationEc2ConfigArgsBuilder internal constructor() {
    private var securityGroupArns: Output<List<String>>? = null

    private var subnetArn: Output<String>? = null

    /**
     * @param value List of Amazon Resource Names (ARNs) of the EC2 Security Groups that are associated with the EFS Mount Target.
     */
    @JvmName("wlspyuhotuxlnqhx")
    public suspend fun securityGroupArns(`value`: Output<List<String>>) {
        this.securityGroupArns = value
    }

    @JvmName("arrgspituormdyjt")
    public suspend fun securityGroupArns(vararg values: Output<String>) {
        this.securityGroupArns = Output.all(values.asList())
    }

    /**
     * @param values List of Amazon Resource Names (ARNs) of the EC2 Security Groups that are associated with the EFS Mount Target.
     */
    @JvmName("fgsmproapsqboksh")
    public suspend fun securityGroupArns(values: List<Output<String>>) {
        this.securityGroupArns = Output.all(values)
    }

    /**
     * @param value Amazon Resource Name (ARN) of the EC2 Subnet that is associated with the EFS Mount Target.
     */
    @JvmName("pulexwkiiuymfpot")
    public suspend fun subnetArn(`value`: Output<String>) {
        this.subnetArn = value
    }

    /**
     * @param value List of Amazon Resource Names (ARNs) of the EC2 Security Groups that are associated with the EFS Mount Target.
     */
    @JvmName("ydovhyhvsjqqqtps")
    public suspend fun securityGroupArns(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroupArns = mapped
    }

    /**
     * @param values List of Amazon Resource Names (ARNs) of the EC2 Security Groups that are associated with the EFS Mount Target.
     */
    @JvmName("iphawntxxppkbook")
    public suspend fun securityGroupArns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroupArns = mapped
    }

    /**
     * @param value Amazon Resource Name (ARN) of the EC2 Subnet that is associated with the EFS Mount Target.
     */
    @JvmName("tprtyntjgjocpvxi")
    public suspend fun subnetArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnetArn = mapped
    }

    internal fun build(): EfsLocationEc2ConfigArgs = EfsLocationEc2ConfigArgs(
        securityGroupArns = securityGroupArns ?: throw PulumiNullFieldException("securityGroupArns"),
        subnetArn = subnetArn ?: throw PulumiNullFieldException("subnetArn"),
    )
}
