@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.datasync.kotlin.inputs

import com.pulumi.aws.datasync.inputs.FsxOpenZfsFileSystemProtocolArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property nfs Represents the Network File System (NFS) protocol that DataSync uses to access your FSx for OpenZFS file system. See below.
 */
public data class FsxOpenZfsFileSystemProtocolArgs(
    public val nfs: Output<FsxOpenZfsFileSystemProtocolNfsArgs>,
) : ConvertibleToJava<com.pulumi.aws.datasync.inputs.FsxOpenZfsFileSystemProtocolArgs> {
    override fun toJava(): com.pulumi.aws.datasync.inputs.FsxOpenZfsFileSystemProtocolArgs =
        com.pulumi.aws.datasync.inputs.FsxOpenZfsFileSystemProtocolArgs.builder()
            .nfs(nfs.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [FsxOpenZfsFileSystemProtocolArgs].
 */
@PulumiTagMarker
public class FsxOpenZfsFileSystemProtocolArgsBuilder internal constructor() {
    private var nfs: Output<FsxOpenZfsFileSystemProtocolNfsArgs>? = null

    /**
     * @param value Represents the Network File System (NFS) protocol that DataSync uses to access your FSx for OpenZFS file system. See below.
     */
    @JvmName("vpghdclgphaddcnq")
    public suspend fun nfs(`value`: Output<FsxOpenZfsFileSystemProtocolNfsArgs>) {
        this.nfs = value
    }

    /**
     * @param value Represents the Network File System (NFS) protocol that DataSync uses to access your FSx for OpenZFS file system. See below.
     */
    @JvmName("grsybollonipfdod")
    public suspend fun nfs(`value`: FsxOpenZfsFileSystemProtocolNfsArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nfs = mapped
    }

    /**
     * @param argument Represents the Network File System (NFS) protocol that DataSync uses to access your FSx for OpenZFS file system. See below.
     */
    @JvmName("yhsqrvpsgfbrubxc")
    public suspend fun nfs(argument: suspend FsxOpenZfsFileSystemProtocolNfsArgsBuilder.() -> Unit) {
        val toBeMapped = FsxOpenZfsFileSystemProtocolNfsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.nfs = mapped
    }

    internal fun build(): FsxOpenZfsFileSystemProtocolArgs = FsxOpenZfsFileSystemProtocolArgs(
        nfs = nfs ?: throw PulumiNullFieldException("nfs"),
    )
}
