@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.datasync.kotlin.inputs

import com.pulumi.aws.datasync.inputs.LocationAzureBlobSasConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property token A SAS token that provides permissions to access your Azure Blob Storage.
 */
public data class LocationAzureBlobSasConfigurationArgs(
    public val token: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.datasync.inputs.LocationAzureBlobSasConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.datasync.inputs.LocationAzureBlobSasConfigurationArgs =
        com.pulumi.aws.datasync.inputs.LocationAzureBlobSasConfigurationArgs.builder()
            .token(token.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LocationAzureBlobSasConfigurationArgs].
 */
@PulumiTagMarker
public class LocationAzureBlobSasConfigurationArgsBuilder internal constructor() {
    private var token: Output<String>? = null

    /**
     * @param value A SAS token that provides permissions to access your Azure Blob Storage.
     */
    @JvmName("klamqxxsuooqmblf")
    public suspend fun token(`value`: Output<String>) {
        this.token = value
    }

    /**
     * @param value A SAS token that provides permissions to access your Azure Blob Storage.
     */
    @JvmName("mvcliiljpebiyqca")
    public suspend fun token(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.token = mapped
    }

    internal fun build(): LocationAzureBlobSasConfigurationArgs =
        LocationAzureBlobSasConfigurationArgs(
            token = token ?: throw PulumiNullFieldException("token"),
        )
}
