@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.datasync.kotlin.inputs

import com.pulumi.aws.datasync.inputs.LocationFsxOntapFileSystemProtocolArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property nfs Network File System (NFS) protocol that DataSync uses to access your FSx ONTAP file system. See NFS below.
 * @property smb Server Message Block (SMB) protocol that DataSync uses to access your FSx ONTAP file system. See [SMB] (#smb) below.
 */
public data class LocationFsxOntapFileSystemProtocolArgs(
    public val nfs: Output<LocationFsxOntapFileSystemProtocolNfsArgs>? = null,
    public val smb: Output<LocationFsxOntapFileSystemProtocolSmbArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.datasync.inputs.LocationFsxOntapFileSystemProtocolArgs> {
    override fun toJava(): com.pulumi.aws.datasync.inputs.LocationFsxOntapFileSystemProtocolArgs =
        com.pulumi.aws.datasync.inputs.LocationFsxOntapFileSystemProtocolArgs.builder()
            .nfs(nfs?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .smb(smb?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [LocationFsxOntapFileSystemProtocolArgs].
 */
@PulumiTagMarker
public class LocationFsxOntapFileSystemProtocolArgsBuilder internal constructor() {
    private var nfs: Output<LocationFsxOntapFileSystemProtocolNfsArgs>? = null

    private var smb: Output<LocationFsxOntapFileSystemProtocolSmbArgs>? = null

    /**
     * @param value Network File System (NFS) protocol that DataSync uses to access your FSx ONTAP file system. See NFS below.
     */
    @JvmName("ocvvcnldjmkornjl")
    public suspend fun nfs(`value`: Output<LocationFsxOntapFileSystemProtocolNfsArgs>) {
        this.nfs = value
    }

    /**
     * @param value Server Message Block (SMB) protocol that DataSync uses to access your FSx ONTAP file system. See [SMB] (#smb) below.
     */
    @JvmName("inqgswcmsmoygvwk")
    public suspend fun smb(`value`: Output<LocationFsxOntapFileSystemProtocolSmbArgs>) {
        this.smb = value
    }

    /**
     * @param value Network File System (NFS) protocol that DataSync uses to access your FSx ONTAP file system. See NFS below.
     */
    @JvmName("mihajpnitonihego")
    public suspend fun nfs(`value`: LocationFsxOntapFileSystemProtocolNfsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nfs = mapped
    }

    /**
     * @param argument Network File System (NFS) protocol that DataSync uses to access your FSx ONTAP file system. See NFS below.
     */
    @JvmName("kkncqnmxjqwksgyd")
    public suspend
    fun nfs(argument: suspend LocationFsxOntapFileSystemProtocolNfsArgsBuilder.() -> Unit) {
        val toBeMapped = LocationFsxOntapFileSystemProtocolNfsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.nfs = mapped
    }

    /**
     * @param value Server Message Block (SMB) protocol that DataSync uses to access your FSx ONTAP file system. See [SMB] (#smb) below.
     */
    @JvmName("vmqngyyhrbxqoank")
    public suspend fun smb(`value`: LocationFsxOntapFileSystemProtocolSmbArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.smb = mapped
    }

    /**
     * @param argument Server Message Block (SMB) protocol that DataSync uses to access your FSx ONTAP file system. See [SMB] (#smb) below.
     */
    @JvmName("umjovvrishqcewmp")
    public suspend
    fun smb(argument: suspend LocationFsxOntapFileSystemProtocolSmbArgsBuilder.() -> Unit) {
        val toBeMapped = LocationFsxOntapFileSystemProtocolSmbArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.smb = mapped
    }

    internal fun build(): LocationFsxOntapFileSystemProtocolArgs =
        LocationFsxOntapFileSystemProtocolArgs(
            nfs = nfs,
            smb = smb,
        )
}
