@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.datasync.kotlin.inputs

import com.pulumi.aws.datasync.inputs.LocationFsxOntapFileSystemProtocolNfsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property mountOptions Mount options that are available for DataSync to access an NFS location. See NFS Mount Options below.
 */
public data class LocationFsxOntapFileSystemProtocolNfsArgs(
    public val mountOptions: Output<LocationFsxOntapFileSystemProtocolNfsMountOptionsArgs>,
) : ConvertibleToJava<com.pulumi.aws.datasync.inputs.LocationFsxOntapFileSystemProtocolNfsArgs> {
    override fun toJava(): com.pulumi.aws.datasync.inputs.LocationFsxOntapFileSystemProtocolNfsArgs =
        com.pulumi.aws.datasync.inputs.LocationFsxOntapFileSystemProtocolNfsArgs.builder()
            .mountOptions(mountOptions.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [LocationFsxOntapFileSystemProtocolNfsArgs].
 */
@PulumiTagMarker
public class LocationFsxOntapFileSystemProtocolNfsArgsBuilder internal constructor() {
    private var mountOptions: Output<LocationFsxOntapFileSystemProtocolNfsMountOptionsArgs>? = null

    /**
     * @param value Mount options that are available for DataSync to access an NFS location. See NFS Mount Options below.
     */
    @JvmName("gdhyicpoqemivgvh")
    public suspend
    fun mountOptions(`value`: Output<LocationFsxOntapFileSystemProtocolNfsMountOptionsArgs>) {
        this.mountOptions = value
    }

    /**
     * @param value Mount options that are available for DataSync to access an NFS location. See NFS Mount Options below.
     */
    @JvmName("atabraweauhbioar")
    public suspend fun mountOptions(`value`: LocationFsxOntapFileSystemProtocolNfsMountOptionsArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mountOptions = mapped
    }

    /**
     * @param argument Mount options that are available for DataSync to access an NFS location. See NFS Mount Options below.
     */
    @JvmName("bgksoxusrtlmukuh")
    public suspend
    fun mountOptions(argument: suspend LocationFsxOntapFileSystemProtocolNfsMountOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = LocationFsxOntapFileSystemProtocolNfsMountOptionsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.mountOptions = mapped
    }

    internal fun build(): LocationFsxOntapFileSystemProtocolNfsArgs =
        LocationFsxOntapFileSystemProtocolNfsArgs(
            mountOptions = mountOptions ?: throw PulumiNullFieldException("mountOptions"),
        )
}
