@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.datasync.kotlin.inputs

import com.pulumi.aws.datasync.inputs.LocationHdfsQopConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property dataTransferProtection The data transfer protection setting configured on the HDFS cluster. This setting corresponds to your dfs.data.transfer.protection setting in the hdfs-site.xml file on your Hadoop cluster. Valid values are `DISABLED`, `AUTHENTICATION`, `INTEGRITY` and `PRIVACY`.
 * @property rpcProtection The RPC protection setting configured on the HDFS cluster. This setting corresponds to your hadoop.rpc.protection setting in your core-site.xml file on your Hadoop cluster. Valid values are `DISABLED`, `AUTHENTICATION`, `INTEGRITY` and `PRIVACY`.
 */
public data class LocationHdfsQopConfigurationArgs(
    public val dataTransferProtection: Output<String>? = null,
    public val rpcProtection: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.datasync.inputs.LocationHdfsQopConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.datasync.inputs.LocationHdfsQopConfigurationArgs =
        com.pulumi.aws.datasync.inputs.LocationHdfsQopConfigurationArgs.builder()
            .dataTransferProtection(dataTransferProtection?.applyValue({ args0 -> args0 }))
            .rpcProtection(rpcProtection?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LocationHdfsQopConfigurationArgs].
 */
@PulumiTagMarker
public class LocationHdfsQopConfigurationArgsBuilder internal constructor() {
    private var dataTransferProtection: Output<String>? = null

    private var rpcProtection: Output<String>? = null

    /**
     * @param value The data transfer protection setting configured on the HDFS cluster. This setting corresponds to your dfs.data.transfer.protection setting in the hdfs-site.xml file on your Hadoop cluster. Valid values are `DISABLED`, `AUTHENTICATION`, `INTEGRITY` and `PRIVACY`.
     */
    @JvmName("fjbckasjgfvekrjs")
    public suspend fun dataTransferProtection(`value`: Output<String>) {
        this.dataTransferProtection = value
    }

    /**
     * @param value The RPC protection setting configured on the HDFS cluster. This setting corresponds to your hadoop.rpc.protection setting in your core-site.xml file on your Hadoop cluster. Valid values are `DISABLED`, `AUTHENTICATION`, `INTEGRITY` and `PRIVACY`.
     */
    @JvmName("wnsqabscrusimqkk")
    public suspend fun rpcProtection(`value`: Output<String>) {
        this.rpcProtection = value
    }

    /**
     * @param value The data transfer protection setting configured on the HDFS cluster. This setting corresponds to your dfs.data.transfer.protection setting in the hdfs-site.xml file on your Hadoop cluster. Valid values are `DISABLED`, `AUTHENTICATION`, `INTEGRITY` and `PRIVACY`.
     */
    @JvmName("yjybkjuelvqrlamk")
    public suspend fun dataTransferProtection(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataTransferProtection = mapped
    }

    /**
     * @param value The RPC protection setting configured on the HDFS cluster. This setting corresponds to your hadoop.rpc.protection setting in your core-site.xml file on your Hadoop cluster. Valid values are `DISABLED`, `AUTHENTICATION`, `INTEGRITY` and `PRIVACY`.
     */
    @JvmName("itlbwldmxtgbbgwn")
    public suspend fun rpcProtection(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rpcProtection = mapped
    }

    internal fun build(): LocationHdfsQopConfigurationArgs = LocationHdfsQopConfigurationArgs(
        dataTransferProtection = dataTransferProtection,
        rpcProtection = rpcProtection,
    )
}
