@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.datasync.kotlin.inputs

import com.pulumi.aws.datasync.inputs.NfsLocationMountOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property version The specific NFS version that you want DataSync to use for mounting your NFS share. Valid values: `AUTOMATIC`, `NFS3`, `NFS4_0` and `NFS4_1`. Default: `AUTOMATIC`
 */
public data class NfsLocationMountOptionsArgs(
    public val version: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.datasync.inputs.NfsLocationMountOptionsArgs> {
    override fun toJava(): com.pulumi.aws.datasync.inputs.NfsLocationMountOptionsArgs =
        com.pulumi.aws.datasync.inputs.NfsLocationMountOptionsArgs.builder()
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NfsLocationMountOptionsArgs].
 */
@PulumiTagMarker
public class NfsLocationMountOptionsArgsBuilder internal constructor() {
    private var version: Output<String>? = null

    /**
     * @param value The specific NFS version that you want DataSync to use for mounting your NFS share. Valid values: `AUTOMATIC`, `NFS3`, `NFS4_0` and `NFS4_1`. Default: `AUTOMATIC`
     */
    @JvmName("aohddphdxtimaquo")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value The specific NFS version that you want DataSync to use for mounting your NFS share. Valid values: `AUTOMATIC`, `NFS3`, `NFS4_0` and `NFS4_1`. Default: `AUTOMATIC`
     */
    @JvmName("sydcvtxpxbkaelkx")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): NfsLocationMountOptionsArgs = NfsLocationMountOptionsArgs(
        version = version,
    )
}
