@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.datasync.kotlin.inputs

import com.pulumi.aws.datasync.inputs.NfsLocationOnPremConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property agentArns List of Amazon Resource Names (ARNs) of the DataSync Agents used to connect to the NFS server.
 */
public data class NfsLocationOnPremConfigArgs(
    public val agentArns: Output<List<String>>,
) : ConvertibleToJava<com.pulumi.aws.datasync.inputs.NfsLocationOnPremConfigArgs> {
    override fun toJava(): com.pulumi.aws.datasync.inputs.NfsLocationOnPremConfigArgs =
        com.pulumi.aws.datasync.inputs.NfsLocationOnPremConfigArgs.builder()
            .agentArns(agentArns.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [NfsLocationOnPremConfigArgs].
 */
@PulumiTagMarker
public class NfsLocationOnPremConfigArgsBuilder internal constructor() {
    private var agentArns: Output<List<String>>? = null

    /**
     * @param value List of Amazon Resource Names (ARNs) of the DataSync Agents used to connect to the NFS server.
     */
    @JvmName("tdoiwpyldeoxaxmw")
    public suspend fun agentArns(`value`: Output<List<String>>) {
        this.agentArns = value
    }

    @JvmName("sgjxodnkxqgeajqt")
    public suspend fun agentArns(vararg values: Output<String>) {
        this.agentArns = Output.all(values.asList())
    }

    /**
     * @param values List of Amazon Resource Names (ARNs) of the DataSync Agents used to connect to the NFS server.
     */
    @JvmName("faxlknhnbfrtwsmh")
    public suspend fun agentArns(values: List<Output<String>>) {
        this.agentArns = Output.all(values)
    }

    /**
     * @param value List of Amazon Resource Names (ARNs) of the DataSync Agents used to connect to the NFS server.
     */
    @JvmName("hapngplhmnthruqi")
    public suspend fun agentArns(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.agentArns = mapped
    }

    /**
     * @param values List of Amazon Resource Names (ARNs) of the DataSync Agents used to connect to the NFS server.
     */
    @JvmName("ryuxpwyutenvuern")
    public suspend fun agentArns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.agentArns = mapped
    }

    internal fun build(): NfsLocationOnPremConfigArgs = NfsLocationOnPremConfigArgs(
        agentArns = agentArns ?: throw PulumiNullFieldException("agentArns"),
    )
}
