@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.datasync.kotlin.inputs

import com.pulumi.aws.datasync.inputs.S3LocationS3ConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property bucketAccessRoleArn ARN of the IAM Role used to connect to the S3 Bucket.
 */
public data class S3LocationS3ConfigArgs(
    public val bucketAccessRoleArn: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.datasync.inputs.S3LocationS3ConfigArgs> {
    override fun toJava(): com.pulumi.aws.datasync.inputs.S3LocationS3ConfigArgs =
        com.pulumi.aws.datasync.inputs.S3LocationS3ConfigArgs.builder()
            .bucketAccessRoleArn(bucketAccessRoleArn.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [S3LocationS3ConfigArgs].
 */
@PulumiTagMarker
public class S3LocationS3ConfigArgsBuilder internal constructor() {
    private var bucketAccessRoleArn: Output<String>? = null

    /**
     * @param value ARN of the IAM Role used to connect to the S3 Bucket.
     */
    @JvmName("lrhfiqjdqtbhgdxd")
    public suspend fun bucketAccessRoleArn(`value`: Output<String>) {
        this.bucketAccessRoleArn = value
    }

    /**
     * @param value ARN of the IAM Role used to connect to the S3 Bucket.
     */
    @JvmName("elhphseyawpxttfs")
    public suspend fun bucketAccessRoleArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bucketAccessRoleArn = mapped
    }

    internal fun build(): S3LocationS3ConfigArgs = S3LocationS3ConfigArgs(
        bucketAccessRoleArn = bucketAccessRoleArn ?: throw PulumiNullFieldException("bucketAccessRoleArn"),
    )
}
