@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.datasync.kotlin.inputs

import com.pulumi.aws.datasync.inputs.TaskExcludesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property filterType The type of filter rule to apply. Valid values: `SIMPLE_PATTERN`.
 * @property value A single filter string that consists of the patterns to exclude. The patterns are delimited by "|" (that is, a pipe), for example: `/folder1|/folder2`
 */
public data class TaskExcludesArgs(
    public val filterType: Output<String>? = null,
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.datasync.inputs.TaskExcludesArgs> {
    override fun toJava(): com.pulumi.aws.datasync.inputs.TaskExcludesArgs =
        com.pulumi.aws.datasync.inputs.TaskExcludesArgs.builder()
            .filterType(filterType?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TaskExcludesArgs].
 */
@PulumiTagMarker
public class TaskExcludesArgsBuilder internal constructor() {
    private var filterType: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value The type of filter rule to apply. Valid values: `SIMPLE_PATTERN`.
     */
    @JvmName("hfbdnqklglcnihse")
    public suspend fun filterType(`value`: Output<String>) {
        this.filterType = value
    }

    /**
     * @param value A single filter string that consists of the patterns to exclude. The patterns are delimited by "|" (that is, a pipe), for example: `/folder1|/folder2`
     */
    @JvmName("xkldklgoasielslp")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value The type of filter rule to apply. Valid values: `SIMPLE_PATTERN`.
     */
    @JvmName("kadwnlhvujwnnhfr")
    public suspend fun filterType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filterType = mapped
    }

    /**
     * @param value A single filter string that consists of the patterns to exclude. The patterns are delimited by "|" (that is, a pipe), for example: `/folder1|/folder2`
     */
    @JvmName("exbogsjqvoebparo")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): TaskExcludesArgs = TaskExcludesArgs(
        filterType = filterType,
        `value` = `value`,
    )
}
