@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.datasync.kotlin.inputs

import com.pulumi.aws.datasync.inputs.TaskOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property atime A file metadata that shows the last time a file was accessed (that is when the file was read or written to). If set to `BEST_EFFORT`, the DataSync Task attempts to preserve the original (that is, the version before sync `PREPARING` phase) `atime` attribute on all source files. Valid values: `BEST_EFFORT`, `NONE`. Default: `BEST_EFFORT`.
 * @property bytesPerSecond Limits the bandwidth utilized. For example, to set a maximum of 1 MB, set this value to `1048576`. Value values: `-1` or greater. Default: `-1` (unlimited).
 * @property gid Group identifier of the file's owners. Valid values: `BOTH`, `INT_VALUE`, `NAME`, `NONE`. Default: `INT_VALUE` (preserve integer value of the ID).
 * @property logLevel Determines the type of logs that DataSync publishes to a log stream in the Amazon CloudWatch log group that you provide. Valid values: `OFF`, `BASIC`, `TRANSFER`. Default: `OFF`.
 * @property mtime A file metadata that indicates the last time a file was modified (written to) before the sync `PREPARING` phase. Value values: `NONE`, `PRESERVE`. Default: `PRESERVE`.
 * @property objectTags Specifies whether object tags are maintained when transferring between object storage systems. If you want your DataSync task to ignore object tags, specify the NONE value. Valid values: `PRESERVE`, `NONE`. Default value: `PRESERVE`.
 * @property overwriteMode Determines whether files at the destination should be overwritten or preserved when copying files. Valid values: `ALWAYS`, `NEVER`. Default: `ALWAYS`.
 * @property posixPermissions Determines which users or groups can access a file for a specific purpose such as reading, writing, or execution of the file. Valid values: `NONE`, `PRESERVE`. Default: `PRESERVE`.
 * @property preserveDeletedFiles Whether files deleted in the source should be removed or preserved in the destination file system. Valid values: `PRESERVE`, `REMOVE`. Default: `PRESERVE`.
 * @property preserveDevices Whether the DataSync Task should preserve the metadata of block and character devices in the source files system, and recreate the files with that device name and metadata on the destination. The DataSync Task can’t sync the actual contents of such devices, because many of the devices are non-terminal and don’t return an end of file (EOF) marker. Valid values: `NONE`, `PRESERVE`. Default: `NONE` (ignore special devices).
 * @property securityDescriptorCopyFlags Determines which components of the SMB security descriptor are copied from source to destination objects. This value is only used for transfers between SMB and Amazon FSx for Windows File Server locations, or between two Amazon FSx for Windows File Server locations. Valid values: `NONE`, `OWNER_DACL`, `OWNER_DACL_SACL`. Default: `OWNER_DACL`.
 * @property taskQueueing Determines whether tasks should be queued before executing the tasks. Valid values: `ENABLED`, `DISABLED`. Default `ENABLED`.
 * @property transferMode Determines whether DataSync transfers only the data and metadata that differ between the source and the destination location, or whether DataSync transfers all the content from the source, without comparing to the destination location. Valid values: `CHANGED`, `ALL`. Default: `CHANGED`
 * @property uid User identifier of the file's owners. Valid values: `BOTH`, `INT_VALUE`, `NAME`, `NONE`. Default: `INT_VALUE` (preserve integer value of the ID).
 * @property verifyMode Whether a data integrity verification should be performed at the end of a task execution after all data and metadata have been transferred. Valid values: `NONE`, `POINT_IN_TIME_CONSISTENT`, `ONLY_FILES_TRANSFERRED`. Default: `POINT_IN_TIME_CONSISTENT`.
 */
public data class TaskOptionsArgs(
    public val atime: Output<String>? = null,
    public val bytesPerSecond: Output<Int>? = null,
    public val gid: Output<String>? = null,
    public val logLevel: Output<String>? = null,
    public val mtime: Output<String>? = null,
    public val objectTags: Output<String>? = null,
    public val overwriteMode: Output<String>? = null,
    public val posixPermissions: Output<String>? = null,
    public val preserveDeletedFiles: Output<String>? = null,
    public val preserveDevices: Output<String>? = null,
    public val securityDescriptorCopyFlags: Output<String>? = null,
    public val taskQueueing: Output<String>? = null,
    public val transferMode: Output<String>? = null,
    public val uid: Output<String>? = null,
    public val verifyMode: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.datasync.inputs.TaskOptionsArgs> {
    override fun toJava(): com.pulumi.aws.datasync.inputs.TaskOptionsArgs =
        com.pulumi.aws.datasync.inputs.TaskOptionsArgs.builder()
            .atime(atime?.applyValue({ args0 -> args0 }))
            .bytesPerSecond(bytesPerSecond?.applyValue({ args0 -> args0 }))
            .gid(gid?.applyValue({ args0 -> args0 }))
            .logLevel(logLevel?.applyValue({ args0 -> args0 }))
            .mtime(mtime?.applyValue({ args0 -> args0 }))
            .objectTags(objectTags?.applyValue({ args0 -> args0 }))
            .overwriteMode(overwriteMode?.applyValue({ args0 -> args0 }))
            .posixPermissions(posixPermissions?.applyValue({ args0 -> args0 }))
            .preserveDeletedFiles(preserveDeletedFiles?.applyValue({ args0 -> args0 }))
            .preserveDevices(preserveDevices?.applyValue({ args0 -> args0 }))
            .securityDescriptorCopyFlags(securityDescriptorCopyFlags?.applyValue({ args0 -> args0 }))
            .taskQueueing(taskQueueing?.applyValue({ args0 -> args0 }))
            .transferMode(transferMode?.applyValue({ args0 -> args0 }))
            .uid(uid?.applyValue({ args0 -> args0 }))
            .verifyMode(verifyMode?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TaskOptionsArgs].
 */
@PulumiTagMarker
public class TaskOptionsArgsBuilder internal constructor() {
    private var atime: Output<String>? = null

    private var bytesPerSecond: Output<Int>? = null

    private var gid: Output<String>? = null

    private var logLevel: Output<String>? = null

    private var mtime: Output<String>? = null

    private var objectTags: Output<String>? = null

    private var overwriteMode: Output<String>? = null

    private var posixPermissions: Output<String>? = null

    private var preserveDeletedFiles: Output<String>? = null

    private var preserveDevices: Output<String>? = null

    private var securityDescriptorCopyFlags: Output<String>? = null

    private var taskQueueing: Output<String>? = null

    private var transferMode: Output<String>? = null

    private var uid: Output<String>? = null

    private var verifyMode: Output<String>? = null

    /**
     * @param value A file metadata that shows the last time a file was accessed (that is when the file was read or written to). If set to `BEST_EFFORT`, the DataSync Task attempts to preserve the original (that is, the version before sync `PREPARING` phase) `atime` attribute on all source files. Valid values: `BEST_EFFORT`, `NONE`. Default: `BEST_EFFORT`.
     */
    @JvmName("ivkbwqcbolyrxwxw")
    public suspend fun atime(`value`: Output<String>) {
        this.atime = value
    }

    /**
     * @param value Limits the bandwidth utilized. For example, to set a maximum of 1 MB, set this value to `1048576`. Value values: `-1` or greater. Default: `-1` (unlimited).
     */
    @JvmName("avfarogdthsblewh")
    public suspend fun bytesPerSecond(`value`: Output<Int>) {
        this.bytesPerSecond = value
    }

    /**
     * @param value Group identifier of the file's owners. Valid values: `BOTH`, `INT_VALUE`, `NAME`, `NONE`. Default: `INT_VALUE` (preserve integer value of the ID).
     */
    @JvmName("thloahmkpoxopgwt")
    public suspend fun gid(`value`: Output<String>) {
        this.gid = value
    }

    /**
     * @param value Determines the type of logs that DataSync publishes to a log stream in the Amazon CloudWatch log group that you provide. Valid values: `OFF`, `BASIC`, `TRANSFER`. Default: `OFF`.
     */
    @JvmName("svjejvyabrtwoclc")
    public suspend fun logLevel(`value`: Output<String>) {
        this.logLevel = value
    }

    /**
     * @param value A file metadata that indicates the last time a file was modified (written to) before the sync `PREPARING` phase. Value values: `NONE`, `PRESERVE`. Default: `PRESERVE`.
     */
    @JvmName("rvvcgtnqwaudsuss")
    public suspend fun mtime(`value`: Output<String>) {
        this.mtime = value
    }

    /**
     * @param value Specifies whether object tags are maintained when transferring between object storage systems. If you want your DataSync task to ignore object tags, specify the NONE value. Valid values: `PRESERVE`, `NONE`. Default value: `PRESERVE`.
     */
    @JvmName("yviqhublgvfyjyrt")
    public suspend fun objectTags(`value`: Output<String>) {
        this.objectTags = value
    }

    /**
     * @param value Determines whether files at the destination should be overwritten or preserved when copying files. Valid values: `ALWAYS`, `NEVER`. Default: `ALWAYS`.
     */
    @JvmName("jxthldhminktnfpa")
    public suspend fun overwriteMode(`value`: Output<String>) {
        this.overwriteMode = value
    }

    /**
     * @param value Determines which users or groups can access a file for a specific purpose such as reading, writing, or execution of the file. Valid values: `NONE`, `PRESERVE`. Default: `PRESERVE`.
     */
    @JvmName("cllkwxsatgrrryxh")
    public suspend fun posixPermissions(`value`: Output<String>) {
        this.posixPermissions = value
    }

    /**
     * @param value Whether files deleted in the source should be removed or preserved in the destination file system. Valid values: `PRESERVE`, `REMOVE`. Default: `PRESERVE`.
     */
    @JvmName("ywclcntoixgsroor")
    public suspend fun preserveDeletedFiles(`value`: Output<String>) {
        this.preserveDeletedFiles = value
    }

    /**
     * @param value Whether the DataSync Task should preserve the metadata of block and character devices in the source files system, and recreate the files with that device name and metadata on the destination. The DataSync Task can’t sync the actual contents of such devices, because many of the devices are non-terminal and don’t return an end of file (EOF) marker. Valid values: `NONE`, `PRESERVE`. Default: `NONE` (ignore special devices).
     */
    @JvmName("jyrlenhxhedwfits")
    public suspend fun preserveDevices(`value`: Output<String>) {
        this.preserveDevices = value
    }

    /**
     * @param value Determines which components of the SMB security descriptor are copied from source to destination objects. This value is only used for transfers between SMB and Amazon FSx for Windows File Server locations, or between two Amazon FSx for Windows File Server locations. Valid values: `NONE`, `OWNER_DACL`, `OWNER_DACL_SACL`. Default: `OWNER_DACL`.
     */
    @JvmName("exbaymkoewjbbxye")
    public suspend fun securityDescriptorCopyFlags(`value`: Output<String>) {
        this.securityDescriptorCopyFlags = value
    }

    /**
     * @param value Determines whether tasks should be queued before executing the tasks. Valid values: `ENABLED`, `DISABLED`. Default `ENABLED`.
     */
    @JvmName("nouqxsaxycaaqtuh")
    public suspend fun taskQueueing(`value`: Output<String>) {
        this.taskQueueing = value
    }

    /**
     * @param value Determines whether DataSync transfers only the data and metadata that differ between the source and the destination location, or whether DataSync transfers all the content from the source, without comparing to the destination location. Valid values: `CHANGED`, `ALL`. Default: `CHANGED`
     */
    @JvmName("seqwyqofwvsltnhm")
    public suspend fun transferMode(`value`: Output<String>) {
        this.transferMode = value
    }

    /**
     * @param value User identifier of the file's owners. Valid values: `BOTH`, `INT_VALUE`, `NAME`, `NONE`. Default: `INT_VALUE` (preserve integer value of the ID).
     */
    @JvmName("gvtidrwyvpfjmxmv")
    public suspend fun uid(`value`: Output<String>) {
        this.uid = value
    }

    /**
     * @param value Whether a data integrity verification should be performed at the end of a task execution after all data and metadata have been transferred. Valid values: `NONE`, `POINT_IN_TIME_CONSISTENT`, `ONLY_FILES_TRANSFERRED`. Default: `POINT_IN_TIME_CONSISTENT`.
     */
    @JvmName("goaeddxcfwbuatyn")
    public suspend fun verifyMode(`value`: Output<String>) {
        this.verifyMode = value
    }

    /**
     * @param value A file metadata that shows the last time a file was accessed (that is when the file was read or written to). If set to `BEST_EFFORT`, the DataSync Task attempts to preserve the original (that is, the version before sync `PREPARING` phase) `atime` attribute on all source files. Valid values: `BEST_EFFORT`, `NONE`. Default: `BEST_EFFORT`.
     */
    @JvmName("ifqkeoaiclnbrgws")
    public suspend fun atime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.atime = mapped
    }

    /**
     * @param value Limits the bandwidth utilized. For example, to set a maximum of 1 MB, set this value to `1048576`. Value values: `-1` or greater. Default: `-1` (unlimited).
     */
    @JvmName("mmanjwynmvsfcbbk")
    public suspend fun bytesPerSecond(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bytesPerSecond = mapped
    }

    /**
     * @param value Group identifier of the file's owners. Valid values: `BOTH`, `INT_VALUE`, `NAME`, `NONE`. Default: `INT_VALUE` (preserve integer value of the ID).
     */
    @JvmName("cskyjxrbjmyooqam")
    public suspend fun gid(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gid = mapped
    }

    /**
     * @param value Determines the type of logs that DataSync publishes to a log stream in the Amazon CloudWatch log group that you provide. Valid values: `OFF`, `BASIC`, `TRANSFER`. Default: `OFF`.
     */
    @JvmName("pbxymaakkcdeowqw")
    public suspend fun logLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logLevel = mapped
    }

    /**
     * @param value A file metadata that indicates the last time a file was modified (written to) before the sync `PREPARING` phase. Value values: `NONE`, `PRESERVE`. Default: `PRESERVE`.
     */
    @JvmName("hmpnrvxsvuvxxvnk")
    public suspend fun mtime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mtime = mapped
    }

    /**
     * @param value Specifies whether object tags are maintained when transferring between object storage systems. If you want your DataSync task to ignore object tags, specify the NONE value. Valid values: `PRESERVE`, `NONE`. Default value: `PRESERVE`.
     */
    @JvmName("fdkfnliuaoweelkv")
    public suspend fun objectTags(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.objectTags = mapped
    }

    /**
     * @param value Determines whether files at the destination should be overwritten or preserved when copying files. Valid values: `ALWAYS`, `NEVER`. Default: `ALWAYS`.
     */
    @JvmName("xblmfoojegiytiju")
    public suspend fun overwriteMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.overwriteMode = mapped
    }

    /**
     * @param value Determines which users or groups can access a file for a specific purpose such as reading, writing, or execution of the file. Valid values: `NONE`, `PRESERVE`. Default: `PRESERVE`.
     */
    @JvmName("ddbyqgpgujpfioaa")
    public suspend fun posixPermissions(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.posixPermissions = mapped
    }

    /**
     * @param value Whether files deleted in the source should be removed or preserved in the destination file system. Valid values: `PRESERVE`, `REMOVE`. Default: `PRESERVE`.
     */
    @JvmName("xeanbhkvehwvoxij")
    public suspend fun preserveDeletedFiles(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preserveDeletedFiles = mapped
    }

    /**
     * @param value Whether the DataSync Task should preserve the metadata of block and character devices in the source files system, and recreate the files with that device name and metadata on the destination. The DataSync Task can’t sync the actual contents of such devices, because many of the devices are non-terminal and don’t return an end of file (EOF) marker. Valid values: `NONE`, `PRESERVE`. Default: `NONE` (ignore special devices).
     */
    @JvmName("iipajjitdmqpspah")
    public suspend fun preserveDevices(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preserveDevices = mapped
    }

    /**
     * @param value Determines which components of the SMB security descriptor are copied from source to destination objects. This value is only used for transfers between SMB and Amazon FSx for Windows File Server locations, or between two Amazon FSx for Windows File Server locations. Valid values: `NONE`, `OWNER_DACL`, `OWNER_DACL_SACL`. Default: `OWNER_DACL`.
     */
    @JvmName("pvalmuboahwcmtpd")
    public suspend fun securityDescriptorCopyFlags(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityDescriptorCopyFlags = mapped
    }

    /**
     * @param value Determines whether tasks should be queued before executing the tasks. Valid values: `ENABLED`, `DISABLED`. Default `ENABLED`.
     */
    @JvmName("gliigdqqnecfdpnp")
    public suspend fun taskQueueing(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.taskQueueing = mapped
    }

    /**
     * @param value Determines whether DataSync transfers only the data and metadata that differ between the source and the destination location, or whether DataSync transfers all the content from the source, without comparing to the destination location. Valid values: `CHANGED`, `ALL`. Default: `CHANGED`
     */
    @JvmName("ufambbmvwjkqcyix")
    public suspend fun transferMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transferMode = mapped
    }

    /**
     * @param value User identifier of the file's owners. Valid values: `BOTH`, `INT_VALUE`, `NAME`, `NONE`. Default: `INT_VALUE` (preserve integer value of the ID).
     */
    @JvmName("tmkmtmfkvnuccxdd")
    public suspend fun uid(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.uid = mapped
    }

    /**
     * @param value Whether a data integrity verification should be performed at the end of a task execution after all data and metadata have been transferred. Valid values: `NONE`, `POINT_IN_TIME_CONSISTENT`, `ONLY_FILES_TRANSFERRED`. Default: `POINT_IN_TIME_CONSISTENT`.
     */
    @JvmName("ehnkitysykkcvdgg")
    public suspend fun verifyMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.verifyMode = mapped
    }

    internal fun build(): TaskOptionsArgs = TaskOptionsArgs(
        atime = atime,
        bytesPerSecond = bytesPerSecond,
        gid = gid,
        logLevel = logLevel,
        mtime = mtime,
        objectTags = objectTags,
        overwriteMode = overwriteMode,
        posixPermissions = posixPermissions,
        preserveDeletedFiles = preserveDeletedFiles,
        preserveDevices = preserveDevices,
        securityDescriptorCopyFlags = securityDescriptorCopyFlags,
        taskQueueing = taskQueueing,
        transferMode = transferMode,
        uid = uid,
        verifyMode = verifyMode,
    )
}
