@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.datasync.kotlin.inputs

import com.pulumi.aws.datasync.inputs.TaskTaskReportConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property outputType Specifies the type of task report you'd like. Valid values: `SUMMARY_ONLY` and `STANDARD`.
 * @property reportLevel Specifies whether you want your task report to include only what went wrong with your transfer or a list of what succeeded and didn't. Valid values: `ERRORS_ONLY` and `SUCCESSES_AND_ERRORS`.
 * @property reportOverrides Configuration block containing the configuration of the reporting level for aspects of your task report. See `report_overrides` below.
 * @property s3Destination Configuration block containing the configuration for the Amazon S3 bucket where DataSync uploads your task report. See `s3_destination` below.
 * @property s3ObjectVersioning Specifies whether your task report includes the new version of each object transferred into an S3 bucket. This only applies if you enable versioning on your bucket. Keep in mind that setting this to INCLUDE can increase the duration of your task execution. Valid values: `INCLUDE` and `NONE`.
 */
public data class TaskTaskReportConfigArgs(
    public val outputType: Output<String>? = null,
    public val reportLevel: Output<String>? = null,
    public val reportOverrides: Output<TaskTaskReportConfigReportOverridesArgs>? = null,
    public val s3Destination: Output<TaskTaskReportConfigS3DestinationArgs>,
    public val s3ObjectVersioning: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.datasync.inputs.TaskTaskReportConfigArgs> {
    override fun toJava(): com.pulumi.aws.datasync.inputs.TaskTaskReportConfigArgs =
        com.pulumi.aws.datasync.inputs.TaskTaskReportConfigArgs.builder()
            .outputType(outputType?.applyValue({ args0 -> args0 }))
            .reportLevel(reportLevel?.applyValue({ args0 -> args0 }))
            .reportOverrides(reportOverrides?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .s3Destination(s3Destination.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .s3ObjectVersioning(s3ObjectVersioning?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TaskTaskReportConfigArgs].
 */
@PulumiTagMarker
public class TaskTaskReportConfigArgsBuilder internal constructor() {
    private var outputType: Output<String>? = null

    private var reportLevel: Output<String>? = null

    private var reportOverrides: Output<TaskTaskReportConfigReportOverridesArgs>? = null

    private var s3Destination: Output<TaskTaskReportConfigS3DestinationArgs>? = null

    private var s3ObjectVersioning: Output<String>? = null

    /**
     * @param value Specifies the type of task report you'd like. Valid values: `SUMMARY_ONLY` and `STANDARD`.
     */
    @JvmName("tonjbnaoijiuukva")
    public suspend fun outputType(`value`: Output<String>) {
        this.outputType = value
    }

    /**
     * @param value Specifies whether you want your task report to include only what went wrong with your transfer or a list of what succeeded and didn't. Valid values: `ERRORS_ONLY` and `SUCCESSES_AND_ERRORS`.
     */
    @JvmName("ahehengjjwrlhmwk")
    public suspend fun reportLevel(`value`: Output<String>) {
        this.reportLevel = value
    }

    /**
     * @param value Configuration block containing the configuration of the reporting level for aspects of your task report. See `report_overrides` below.
     */
    @JvmName("sqeilfolcuxiyuwc")
    public suspend fun reportOverrides(`value`: Output<TaskTaskReportConfigReportOverridesArgs>) {
        this.reportOverrides = value
    }

    /**
     * @param value Configuration block containing the configuration for the Amazon S3 bucket where DataSync uploads your task report. See `s3_destination` below.
     */
    @JvmName("hwmujfmodaerhwsk")
    public suspend fun s3Destination(`value`: Output<TaskTaskReportConfigS3DestinationArgs>) {
        this.s3Destination = value
    }

    /**
     * @param value Specifies whether your task report includes the new version of each object transferred into an S3 bucket. This only applies if you enable versioning on your bucket. Keep in mind that setting this to INCLUDE can increase the duration of your task execution. Valid values: `INCLUDE` and `NONE`.
     */
    @JvmName("nvekomawaplqcons")
    public suspend fun s3ObjectVersioning(`value`: Output<String>) {
        this.s3ObjectVersioning = value
    }

    /**
     * @param value Specifies the type of task report you'd like. Valid values: `SUMMARY_ONLY` and `STANDARD`.
     */
    @JvmName("unwryrifcsuhycph")
    public suspend fun outputType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.outputType = mapped
    }

    /**
     * @param value Specifies whether you want your task report to include only what went wrong with your transfer or a list of what succeeded and didn't. Valid values: `ERRORS_ONLY` and `SUCCESSES_AND_ERRORS`.
     */
    @JvmName("ymgflealvjqsrwsc")
    public suspend fun reportLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.reportLevel = mapped
    }

    /**
     * @param value Configuration block containing the configuration of the reporting level for aspects of your task report. See `report_overrides` below.
     */
    @JvmName("hkabegwqmhyglruc")
    public suspend fun reportOverrides(`value`: TaskTaskReportConfigReportOverridesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.reportOverrides = mapped
    }

    /**
     * @param argument Configuration block containing the configuration of the reporting level for aspects of your task report. See `report_overrides` below.
     */
    @JvmName("hnlprmwociqotmwu")
    public suspend
    fun reportOverrides(argument: suspend TaskTaskReportConfigReportOverridesArgsBuilder.() -> Unit) {
        val toBeMapped = TaskTaskReportConfigReportOverridesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.reportOverrides = mapped
    }

    /**
     * @param value Configuration block containing the configuration for the Amazon S3 bucket where DataSync uploads your task report. See `s3_destination` below.
     */
    @JvmName("ggnfjrhuyawejnoi")
    public suspend fun s3Destination(`value`: TaskTaskReportConfigS3DestinationArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.s3Destination = mapped
    }

    /**
     * @param argument Configuration block containing the configuration for the Amazon S3 bucket where DataSync uploads your task report. See `s3_destination` below.
     */
    @JvmName("njnbctrcvkdehqxq")
    public suspend
    fun s3Destination(argument: suspend TaskTaskReportConfigS3DestinationArgsBuilder.() -> Unit) {
        val toBeMapped = TaskTaskReportConfigS3DestinationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.s3Destination = mapped
    }

    /**
     * @param value Specifies whether your task report includes the new version of each object transferred into an S3 bucket. This only applies if you enable versioning on your bucket. Keep in mind that setting this to INCLUDE can increase the duration of your task execution. Valid values: `INCLUDE` and `NONE`.
     */
    @JvmName("nigopnjgldsthgfd")
    public suspend fun s3ObjectVersioning(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3ObjectVersioning = mapped
    }

    internal fun build(): TaskTaskReportConfigArgs = TaskTaskReportConfigArgs(
        outputType = outputType,
        reportLevel = reportLevel,
        reportOverrides = reportOverrides,
        s3Destination = s3Destination ?: throw PulumiNullFieldException("s3Destination"),
        s3ObjectVersioning = s3ObjectVersioning,
    )
}
