@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.datasync.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property hostname The hostname of the NameNode in the HDFS cluster. This value is the IP address or Domain Name Service (DNS) name of the NameNode. An agent that's installed on-premises uses this hostname to communicate with the NameNode in the network.
 * @property port The port that the NameNode uses to listen to client requests.
 */
public data class LocationHdfsNameNode(
    public val hostname: String,
    public val port: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.datasync.outputs.LocationHdfsNameNode):
            LocationHdfsNameNode = LocationHdfsNameNode(
            hostname = javaType.hostname(),
            port = javaType.port(),
        )
    }
}
