@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.datasync.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property version The specific SMB version that you want DataSync to use for mounting your SMB share. Valid values: `AUTOMATIC`, `SMB2`, and `SMB3`. Default: `AUTOMATIC`
 */
public data class LocationSmbMountOptions(
    public val version: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.datasync.outputs.LocationSmbMountOptions):
            LocationSmbMountOptions = LocationSmbMountOptions(
            version = javaType.version().map({ args0 -> args0 }).orElse(null),
        )
    }
}
