@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.datasync.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property agentArns List of Amazon Resource Names (ARNs) of the DataSync Agents used to connect to the NFS server.
 */
public data class NfsLocationOnPremConfig(
    public val agentArns: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.datasync.outputs.NfsLocationOnPremConfig):
            NfsLocationOnPremConfig = NfsLocationOnPremConfig(
            agentArns = javaType.agentArns().map({ args0 -> args0 }),
        )
    }
}
