@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.datasync.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property atime A file metadata that shows the last time a file was accessed (that is when the file was read or written to). If set to `BEST_EFFORT`, the DataSync Task attempts to preserve the original (that is, the version before sync `PREPARING` phase) `atime` attribute on all source files. Valid values: `BEST_EFFORT`, `NONE`. Default: `BEST_EFFORT`.
 * @property bytesPerSecond Limits the bandwidth utilized. For example, to set a maximum of 1 MB, set this value to `1048576`. Value values: `-1` or greater. Default: `-1` (unlimited).
 * @property gid Group identifier of the file's owners. Valid values: `BOTH`, `INT_VALUE`, `NAME`, `NONE`. Default: `INT_VALUE` (preserve integer value of the ID).
 * @property logLevel Determines the type of logs that DataSync publishes to a log stream in the Amazon CloudWatch log group that you provide. Valid values: `OFF`, `BASIC`, `TRANSFER`. Default: `OFF`.
 * @property mtime A file metadata that indicates the last time a file was modified (written to) before the sync `PREPARING` phase. Value values: `NONE`, `PRESERVE`. Default: `PRESERVE`.
 * @property objectTags Specifies whether object tags are maintained when transferring between object storage systems. If you want your DataSync task to ignore object tags, specify the NONE value. Valid values: `PRESERVE`, `NONE`. Default value: `PRESERVE`.
 * @property overwriteMode Determines whether files at the destination should be overwritten or preserved when copying files. Valid values: `ALWAYS`, `NEVER`. Default: `ALWAYS`.
 * @property posixPermissions Determines which users or groups can access a file for a specific purpose such as reading, writing, or execution of the file. Valid values: `NONE`, `PRESERVE`. Default: `PRESERVE`.
 * @property preserveDeletedFiles Whether files deleted in the source should be removed or preserved in the destination file system. Valid values: `PRESERVE`, `REMOVE`. Default: `PRESERVE`.
 * @property preserveDevices Whether the DataSync Task should preserve the metadata of block and character devices in the source files system, and recreate the files with that device name and metadata on the destination. The DataSync Task can’t sync the actual contents of such devices, because many of the devices are non-terminal and don’t return an end of file (EOF) marker. Valid values: `NONE`, `PRESERVE`. Default: `NONE` (ignore special devices).
 * @property securityDescriptorCopyFlags Determines which components of the SMB security descriptor are copied from source to destination objects. This value is only used for transfers between SMB and Amazon FSx for Windows File Server locations, or between two Amazon FSx for Windows File Server locations. Valid values: `NONE`, `OWNER_DACL`, `OWNER_DACL_SACL`. Default: `OWNER_DACL`.
 * @property taskQueueing Determines whether tasks should be queued before executing the tasks. Valid values: `ENABLED`, `DISABLED`. Default `ENABLED`.
 * @property transferMode Determines whether DataSync transfers only the data and metadata that differ between the source and the destination location, or whether DataSync transfers all the content from the source, without comparing to the destination location. Valid values: `CHANGED`, `ALL`. Default: `CHANGED`
 * @property uid User identifier of the file's owners. Valid values: `BOTH`, `INT_VALUE`, `NAME`, `NONE`. Default: `INT_VALUE` (preserve integer value of the ID).
 * @property verifyMode Whether a data integrity verification should be performed at the end of a task execution after all data and metadata have been transferred. Valid values: `NONE`, `POINT_IN_TIME_CONSISTENT`, `ONLY_FILES_TRANSFERRED`. Default: `POINT_IN_TIME_CONSISTENT`.
 */
public data class TaskOptions(
    public val atime: String? = null,
    public val bytesPerSecond: Int? = null,
    public val gid: String? = null,
    public val logLevel: String? = null,
    public val mtime: String? = null,
    public val objectTags: String? = null,
    public val overwriteMode: String? = null,
    public val posixPermissions: String? = null,
    public val preserveDeletedFiles: String? = null,
    public val preserveDevices: String? = null,
    public val securityDescriptorCopyFlags: String? = null,
    public val taskQueueing: String? = null,
    public val transferMode: String? = null,
    public val uid: String? = null,
    public val verifyMode: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.datasync.outputs.TaskOptions): TaskOptions =
            TaskOptions(
                atime = javaType.atime().map({ args0 -> args0 }).orElse(null),
                bytesPerSecond = javaType.bytesPerSecond().map({ args0 -> args0 }).orElse(null),
                gid = javaType.gid().map({ args0 -> args0 }).orElse(null),
                logLevel = javaType.logLevel().map({ args0 -> args0 }).orElse(null),
                mtime = javaType.mtime().map({ args0 -> args0 }).orElse(null),
                objectTags = javaType.objectTags().map({ args0 -> args0 }).orElse(null),
                overwriteMode = javaType.overwriteMode().map({ args0 -> args0 }).orElse(null),
                posixPermissions = javaType.posixPermissions().map({ args0 -> args0 }).orElse(null),
                preserveDeletedFiles = javaType.preserveDeletedFiles().map({ args0 -> args0 }).orElse(null),
                preserveDevices = javaType.preserveDevices().map({ args0 -> args0 }).orElse(null),
                securityDescriptorCopyFlags = javaType.securityDescriptorCopyFlags().map({ args0 ->
                    args0
                }).orElse(null),
                taskQueueing = javaType.taskQueueing().map({ args0 -> args0 }).orElse(null),
                transferMode = javaType.transferMode().map({ args0 -> args0 }).orElse(null),
                uid = javaType.uid().map({ args0 -> args0 }).orElse(null),
                verifyMode = javaType.verifyMode().map({ args0 -> args0 }).orElse(null),
            )
    }
}
