@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.datasync.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property outputType Specifies the type of task report you'd like. Valid values: `SUMMARY_ONLY` and `STANDARD`.
 * @property reportLevel Specifies whether you want your task report to include only what went wrong with your transfer or a list of what succeeded and didn't. Valid values: `ERRORS_ONLY` and `SUCCESSES_AND_ERRORS`.
 * @property reportOverrides Configuration block containing the configuration of the reporting level for aspects of your task report. See `report_overrides` below.
 * @property s3Destination Configuration block containing the configuration for the Amazon S3 bucket where DataSync uploads your task report. See `s3_destination` below.
 * @property s3ObjectVersioning Specifies whether your task report includes the new version of each object transferred into an S3 bucket. This only applies if you enable versioning on your bucket. Keep in mind that setting this to INCLUDE can increase the duration of your task execution. Valid values: `INCLUDE` and `NONE`.
 */
public data class TaskTaskReportConfig(
    public val outputType: String? = null,
    public val reportLevel: String? = null,
    public val reportOverrides: TaskTaskReportConfigReportOverrides? = null,
    public val s3Destination: TaskTaskReportConfigS3Destination,
    public val s3ObjectVersioning: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.datasync.outputs.TaskTaskReportConfig):
            TaskTaskReportConfig = TaskTaskReportConfig(
            outputType = javaType.outputType().map({ args0 -> args0 }).orElse(null),
            reportLevel = javaType.reportLevel().map({ args0 -> args0 }).orElse(null),
            reportOverrides = javaType.reportOverrides().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.datasync.kotlin.outputs.TaskTaskReportConfigReportOverrides.Companion.toKotlin(args0)
                })
            }).orElse(null),
            s3Destination = javaType.s3Destination().let({ args0 ->
                com.pulumi.aws.datasync.kotlin.outputs.TaskTaskReportConfigS3Destination.Companion.toKotlin(args0)
            }),
            s3ObjectVersioning = javaType.s3ObjectVersioning().map({ args0 -> args0 }).orElse(null),
        )
    }
}
