@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dax.kotlin

import com.pulumi.aws.dax.ClusterArgs.builder
import com.pulumi.aws.dax.kotlin.inputs.ClusterServerSideEncryptionArgs
import com.pulumi.aws.dax.kotlin.inputs.ClusterServerSideEncryptionArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a DAX Cluster resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.dax.Cluster;
 * import com.pulumi.aws.dax.ClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var bar = new Cluster("bar", ClusterArgs.builder()
 *             .clusterName("cluster-example")
 *             .iamRoleArn(data.aws_iam_role().example().arn())
 *             .nodeType("dax.r4.large")
 *             .replicationFactor(1)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import DAX Clusters using the `cluster_name`. For example:
 * ```sh
 *  $ pulumi import aws:dax/cluster:Cluster my_cluster my_cluster
 * ```
 * @property availabilityZones List of Availability Zones in which the
 * nodes will be created
 * @property clusterEndpointEncryptionType The type of encryption the
 * cluster's endpoint should support. Valid values are: `NONE` and `TLS`.
 * Default value is `NONE`.
 * @property clusterName Group identifier. DAX converts this name to
 * lowercase
 * @property description Description for the cluster
 * @property iamRoleArn A valid Amazon Resource Name (ARN) that identifies
 * an IAM role. At runtime, DAX will assume this role and use the role's
 * permissions to access DynamoDB on your behalf
 * @property maintenanceWindow Specifies the weekly time range for when
 * maintenance on the cluster is performed. The format is `ddd:hh24:mi-ddd:hh24:mi`
 * (24H Clock UTC). The minimum maintenance window is a 60 minute period. Example:
 * `sun:05:00-sun:09:00`
 * @property nodeType The compute and memory capacity of the nodes. See
 * [Nodes](http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/DAX.concepts.cluster.html#DAX.concepts.nodes) for supported node types
 * @property notificationTopicArn An Amazon Resource Name (ARN) of an
 * SNS topic to send DAX notifications to. Example:
 * `arn:aws:sns:us-east-1:012345678999:my_sns_topic`
 * @property parameterGroupName Name of the parameter group to associate
 * with this DAX cluster
 * @property replicationFactor The number of nodes in the DAX cluster. A
 * replication factor of 1 will create a single-node cluster, without any read
 * replicas
 * @property securityGroupIds One or more VPC security groups associated
 * with the cluster
 * @property serverSideEncryption Encrypt at rest options
 * @property subnetGroupName Name of the subnet group to be used for the
 * cluster
 * @property tags A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class ClusterArgs(
    public val availabilityZones: Output<List<String>>? = null,
    public val clusterEndpointEncryptionType: Output<String>? = null,
    public val clusterName: Output<String>? = null,
    public val description: Output<String>? = null,
    public val iamRoleArn: Output<String>? = null,
    public val maintenanceWindow: Output<String>? = null,
    public val nodeType: Output<String>? = null,
    public val notificationTopicArn: Output<String>? = null,
    public val parameterGroupName: Output<String>? = null,
    public val replicationFactor: Output<Int>? = null,
    public val securityGroupIds: Output<List<String>>? = null,
    public val serverSideEncryption: Output<ClusterServerSideEncryptionArgs>? = null,
    public val subnetGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.dax.ClusterArgs> {
    override fun toJava(): com.pulumi.aws.dax.ClusterArgs = com.pulumi.aws.dax.ClusterArgs.builder()
        .availabilityZones(availabilityZones?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
        .clusterEndpointEncryptionType(clusterEndpointEncryptionType?.applyValue({ args0 -> args0 }))
        .clusterName(clusterName?.applyValue({ args0 -> args0 }))
        .description(description?.applyValue({ args0 -> args0 }))
        .iamRoleArn(iamRoleArn?.applyValue({ args0 -> args0 }))
        .maintenanceWindow(maintenanceWindow?.applyValue({ args0 -> args0 }))
        .nodeType(nodeType?.applyValue({ args0 -> args0 }))
        .notificationTopicArn(notificationTopicArn?.applyValue({ args0 -> args0 }))
        .parameterGroupName(parameterGroupName?.applyValue({ args0 -> args0 }))
        .replicationFactor(replicationFactor?.applyValue({ args0 -> args0 }))
        .securityGroupIds(securityGroupIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
        .serverSideEncryption(
            serverSideEncryption?.applyValue({ args0 ->
                args0.let({ args0 ->
                    args0.toJava()
                })
            }),
        )
        .subnetGroupName(subnetGroupName?.applyValue({ args0 -> args0 }))
        .tags(
            tags?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }),
        ).build()
}

/**
 * Builder for [ClusterArgs].
 */
@PulumiTagMarker
public class ClusterArgsBuilder internal constructor() {
    private var availabilityZones: Output<List<String>>? = null

    private var clusterEndpointEncryptionType: Output<String>? = null

    private var clusterName: Output<String>? = null

    private var description: Output<String>? = null

    private var iamRoleArn: Output<String>? = null

    private var maintenanceWindow: Output<String>? = null

    private var nodeType: Output<String>? = null

    private var notificationTopicArn: Output<String>? = null

    private var parameterGroupName: Output<String>? = null

    private var replicationFactor: Output<Int>? = null

    private var securityGroupIds: Output<List<String>>? = null

    private var serverSideEncryption: Output<ClusterServerSideEncryptionArgs>? = null

    private var subnetGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value List of Availability Zones in which the
     * nodes will be created
     */
    @JvmName("jigxkxoosqkgjqar")
    public suspend fun availabilityZones(`value`: Output<List<String>>) {
        this.availabilityZones = value
    }

    @JvmName("ojyfxufijsniqyie")
    public suspend fun availabilityZones(vararg values: Output<String>) {
        this.availabilityZones = Output.all(values.asList())
    }

    /**
     * @param values List of Availability Zones in which the
     * nodes will be created
     */
    @JvmName("tccmofstxcmlhftw")
    public suspend fun availabilityZones(values: List<Output<String>>) {
        this.availabilityZones = Output.all(values)
    }

    /**
     * @param value The type of encryption the
     * cluster's endpoint should support. Valid values are: `NONE` and `TLS`.
     * Default value is `NONE`.
     */
    @JvmName("lqoewkivcpdkntys")
    public suspend fun clusterEndpointEncryptionType(`value`: Output<String>) {
        this.clusterEndpointEncryptionType = value
    }

    /**
     * @param value Group identifier. DAX converts this name to
     * lowercase
     */
    @JvmName("egxpxhkhskliofvl")
    public suspend fun clusterName(`value`: Output<String>) {
        this.clusterName = value
    }

    /**
     * @param value Description for the cluster
     */
    @JvmName("ulwogkcvbpxrxxoe")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value A valid Amazon Resource Name (ARN) that identifies
     * an IAM role. At runtime, DAX will assume this role and use the role's
     * permissions to access DynamoDB on your behalf
     */
    @JvmName("kedqrjaplbcmmvkf")
    public suspend fun iamRoleArn(`value`: Output<String>) {
        this.iamRoleArn = value
    }

    /**
     * @param value Specifies the weekly time range for when
     * maintenance on the cluster is performed. The format is `ddd:hh24:mi-ddd:hh24:mi`
     * (24H Clock UTC). The minimum maintenance window is a 60 minute period. Example:
     * `sun:05:00-sun:09:00`
     */
    @JvmName("tkojfsemrhrwexnl")
    public suspend fun maintenanceWindow(`value`: Output<String>) {
        this.maintenanceWindow = value
    }

    /**
     * @param value The compute and memory capacity of the nodes. See
     * [Nodes](http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/DAX.concepts.cluster.html#DAX.concepts.nodes) for supported node types
     */
    @JvmName("ksfyelnnroenoyhn")
    public suspend fun nodeType(`value`: Output<String>) {
        this.nodeType = value
    }

    /**
     * @param value An Amazon Resource Name (ARN) of an
     * SNS topic to send DAX notifications to. Example:
     * `arn:aws:sns:us-east-1:012345678999:my_sns_topic`
     */
    @JvmName("khoohpxfastvjunu")
    public suspend fun notificationTopicArn(`value`: Output<String>) {
        this.notificationTopicArn = value
    }

    /**
     * @param value Name of the parameter group to associate
     * with this DAX cluster
     */
    @JvmName("mnwywewhperlbaej")
    public suspend fun parameterGroupName(`value`: Output<String>) {
        this.parameterGroupName = value
    }

    /**
     * @param value The number of nodes in the DAX cluster. A
     * replication factor of 1 will create a single-node cluster, without any read
     * replicas
     */
    @JvmName("qjjusejqysprrhol")
    public suspend fun replicationFactor(`value`: Output<Int>) {
        this.replicationFactor = value
    }

    /**
     * @param value One or more VPC security groups associated
     * with the cluster
     */
    @JvmName("yvwiyegcokapbujd")
    public suspend fun securityGroupIds(`value`: Output<List<String>>) {
        this.securityGroupIds = value
    }

    @JvmName("desdhwdjuafknrts")
    public suspend fun securityGroupIds(vararg values: Output<String>) {
        this.securityGroupIds = Output.all(values.asList())
    }

    /**
     * @param values One or more VPC security groups associated
     * with the cluster
     */
    @JvmName("kexfgtrtfdmegtqo")
    public suspend fun securityGroupIds(values: List<Output<String>>) {
        this.securityGroupIds = Output.all(values)
    }

    /**
     * @param value Encrypt at rest options
     */
    @JvmName("qucuthfaopgcvdug")
    public suspend fun serverSideEncryption(`value`: Output<ClusterServerSideEncryptionArgs>) {
        this.serverSideEncryption = value
    }

    /**
     * @param value Name of the subnet group to be used for the
     * cluster
     */
    @JvmName("bybbdbxafudshegr")
    public suspend fun subnetGroupName(`value`: Output<String>) {
        this.subnetGroupName = value
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("gvpjauylxfxrrdys")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value List of Availability Zones in which the
     * nodes will be created
     */
    @JvmName("jblpovdlproukovj")
    public suspend fun availabilityZones(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.availabilityZones = mapped
    }

    /**
     * @param values List of Availability Zones in which the
     * nodes will be created
     */
    @JvmName("vytsephmwjjwnewc")
    public suspend fun availabilityZones(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.availabilityZones = mapped
    }

    /**
     * @param value The type of encryption the
     * cluster's endpoint should support. Valid values are: `NONE` and `TLS`.
     * Default value is `NONE`.
     */
    @JvmName("rwqdavkssqnxdots")
    public suspend fun clusterEndpointEncryptionType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterEndpointEncryptionType = mapped
    }

    /**
     * @param value Group identifier. DAX converts this name to
     * lowercase
     */
    @JvmName("inlhnollpxigukxt")
    public suspend fun clusterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterName = mapped
    }

    /**
     * @param value Description for the cluster
     */
    @JvmName("grwjtvheyapiyptx")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value A valid Amazon Resource Name (ARN) that identifies
     * an IAM role. At runtime, DAX will assume this role and use the role's
     * permissions to access DynamoDB on your behalf
     */
    @JvmName("mmhkoppvjtwubjmy")
    public suspend fun iamRoleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.iamRoleArn = mapped
    }

    /**
     * @param value Specifies the weekly time range for when
     * maintenance on the cluster is performed. The format is `ddd:hh24:mi-ddd:hh24:mi`
     * (24H Clock UTC). The minimum maintenance window is a 60 minute period. Example:
     * `sun:05:00-sun:09:00`
     */
    @JvmName("wjdmannaupwrxlom")
    public suspend fun maintenanceWindow(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maintenanceWindow = mapped
    }

    /**
     * @param value The compute and memory capacity of the nodes. See
     * [Nodes](http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/DAX.concepts.cluster.html#DAX.concepts.nodes) for supported node types
     */
    @JvmName("bhkabaiycrsslknm")
    public suspend fun nodeType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nodeType = mapped
    }

    /**
     * @param value An Amazon Resource Name (ARN) of an
     * SNS topic to send DAX notifications to. Example:
     * `arn:aws:sns:us-east-1:012345678999:my_sns_topic`
     */
    @JvmName("sgtwxntyhofugmgy")
    public suspend fun notificationTopicArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notificationTopicArn = mapped
    }

    /**
     * @param value Name of the parameter group to associate
     * with this DAX cluster
     */
    @JvmName("evwrobpgdjqfdcrm")
    public suspend fun parameterGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameterGroupName = mapped
    }

    /**
     * @param value The number of nodes in the DAX cluster. A
     * replication factor of 1 will create a single-node cluster, without any read
     * replicas
     */
    @JvmName("uceymydlcfupiqil")
    public suspend fun replicationFactor(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replicationFactor = mapped
    }

    /**
     * @param value One or more VPC security groups associated
     * with the cluster
     */
    @JvmName("bymljnvhtgculwur")
    public suspend fun securityGroupIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param values One or more VPC security groups associated
     * with the cluster
     */
    @JvmName("dxrgpondavjsdgoc")
    public suspend fun securityGroupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param value Encrypt at rest options
     */
    @JvmName("whoeucbwdgqnwvfc")
    public suspend fun serverSideEncryption(`value`: ClusterServerSideEncryptionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverSideEncryption = mapped
    }

    /**
     * @param argument Encrypt at rest options
     */
    @JvmName("osghsskfmbdgtbxj")
    public suspend
    fun serverSideEncryption(argument: suspend ClusterServerSideEncryptionArgsBuilder.() -> Unit) {
        val toBeMapped = ClusterServerSideEncryptionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.serverSideEncryption = mapped
    }

    /**
     * @param value Name of the subnet group to be used for the
     * cluster
     */
    @JvmName("ylhhrbvbmgthdftt")
    public suspend fun subnetGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetGroupName = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("pxsmpvasjbjaspsf")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("iwxchmevlhysvxtx")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ClusterArgs = ClusterArgs(
        availabilityZones = availabilityZones,
        clusterEndpointEncryptionType = clusterEndpointEncryptionType,
        clusterName = clusterName,
        description = description,
        iamRoleArn = iamRoleArn,
        maintenanceWindow = maintenanceWindow,
        nodeType = nodeType,
        notificationTopicArn = notificationTopicArn,
        parameterGroupName = parameterGroupName,
        replicationFactor = replicationFactor,
        securityGroupIds = securityGroupIds,
        serverSideEncryption = serverSideEncryption,
        subnetGroupName = subnetGroupName,
        tags = tags,
    )
}
