@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dax.kotlin

import com.pulumi.aws.dax.kotlin.outputs.ParameterGroupParameter
import com.pulumi.aws.dax.kotlin.outputs.ParameterGroupParameter.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [ParameterGroup].
 */
@PulumiTagMarker
public class ParameterGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ParameterGroupArgs = ParameterGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ParameterGroupArgsBuilder.() -> Unit) {
        val builder = ParameterGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ParameterGroup {
        val builtJavaResource = com.pulumi.aws.dax.ParameterGroup(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ParameterGroup(builtJavaResource)
    }
}

/**
 * Provides a DAX Parameter Group resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.dax.ParameterGroup;
 * import com.pulumi.aws.dax.ParameterGroupArgs;
 * import com.pulumi.aws.dax.inputs.ParameterGroupParameterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ParameterGroup("example", ParameterGroupArgs.builder()
 *             .parameters(
 *                 ParameterGroupParameterArgs.builder()
 *                     .name("query-ttl-millis")
 *                     .value("100000")
 *                     .build(),
 *                 ParameterGroupParameterArgs.builder()
 *                     .name("record-ttl-millis")
 *                     .value("100000")
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import DAX Parameter Group using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:dax/parameterGroup:ParameterGroup example my_dax_pg
 * ```
 *
 */
public class ParameterGroup internal constructor(
    override val javaResource: com.pulumi.aws.dax.ParameterGroup,
) : KotlinCustomResource(javaResource, ParameterGroupMapper) {
    /**
     * A description of the parameter group.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the parameter group.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The parameters of the parameter group.
     */
    public val parameters: Output<List<ParameterGroupParameter>>
        get() = javaResource.parameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            })
        })
}

public object ParameterGroupMapper : ResourceMapper<ParameterGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.dax.ParameterGroup::class == javaResource::class

    override fun map(javaResource: Resource): ParameterGroup = ParameterGroup(
        javaResource as
            com.pulumi.aws.dax.ParameterGroup,
    )
}

/**
 * @see [ParameterGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ParameterGroup].
 */
public suspend fun parameterGroup(
    name: String,
    block: suspend ParameterGroupResourceBuilder.() -> Unit,
): ParameterGroup {
    val builder = ParameterGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ParameterGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun parameterGroup(name: String): ParameterGroup {
    val builder = ParameterGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
