@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dax.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [SubnetGroup].
 */
@PulumiTagMarker
public class SubnetGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SubnetGroupArgs = SubnetGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SubnetGroupArgsBuilder.() -> Unit) {
        val builder = SubnetGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): SubnetGroup {
        val builtJavaResource = com.pulumi.aws.dax.SubnetGroup(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return SubnetGroup(builtJavaResource)
    }
}

/**
 * Provides a DAX Subnet Group resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.dax.SubnetGroup;
 * import com.pulumi.aws.dax.SubnetGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new SubnetGroup("example", SubnetGroupArgs.builder()
 *             .subnetIds(
 *                 aws_subnet.example1().id(),
 *                 aws_subnet.example2().id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import DAX Subnet Group using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:dax/subnetGroup:SubnetGroup example my_dax_sg
 * ```
 *
 */
public class SubnetGroup internal constructor(
    override val javaResource: com.pulumi.aws.dax.SubnetGroup,
) : KotlinCustomResource(javaResource, SubnetGroupMapper) {
    /**
     * A description of the subnet group.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the subnet group.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * A list of VPC subnet IDs for the subnet group.
     */
    public val subnetIds: Output<List<String>>
        get() = javaResource.subnetIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * VPC ID of the subnet group.
     */
    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })
}

public object SubnetGroupMapper : ResourceMapper<SubnetGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.dax.SubnetGroup::class == javaResource::class

    override fun map(javaResource: Resource): SubnetGroup = SubnetGroup(
        javaResource as
            com.pulumi.aws.dax.SubnetGroup,
    )
}

/**
 * @see [SubnetGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SubnetGroup].
 */
public suspend fun subnetGroup(name: String, block: suspend SubnetGroupResourceBuilder.() -> Unit):
    SubnetGroup {
    val builder = SubnetGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SubnetGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun subnetGroup(name: String): SubnetGroup {
    val builder = SubnetGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
