@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dax.kotlin

import com.pulumi.aws.dax.SubnetGroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a DAX Subnet Group resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.dax.SubnetGroup;
 * import com.pulumi.aws.dax.SubnetGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new SubnetGroup("example", SubnetGroupArgs.builder()
 *             .subnetIds(
 *                 aws_subnet.example1().id(),
 *                 aws_subnet.example2().id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import DAX Subnet Group using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:dax/subnetGroup:SubnetGroup example my_dax_sg
 * ```
 * @property description A description of the subnet group.
 * @property name The name of the subnet group.
 * @property subnetIds A list of VPC subnet IDs for the subnet group.
 */
public data class SubnetGroupArgs(
    public val description: Output<String>? = null,
    public val name: Output<String>? = null,
    public val subnetIds: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.dax.SubnetGroupArgs> {
    override fun toJava(): com.pulumi.aws.dax.SubnetGroupArgs =
        com.pulumi.aws.dax.SubnetGroupArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .subnetIds(subnetIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [SubnetGroupArgs].
 */
@PulumiTagMarker
public class SubnetGroupArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var name: Output<String>? = null

    private var subnetIds: Output<List<String>>? = null

    /**
     * @param value A description of the subnet group.
     */
    @JvmName("wdijnffewgstinsh")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The name of the subnet group.
     */
    @JvmName("kvhjgqnupvjdnbmn")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A list of VPC subnet IDs for the subnet group.
     */
    @JvmName("rclurbrqjfbywrhd")
    public suspend fun subnetIds(`value`: Output<List<String>>) {
        this.subnetIds = value
    }

    @JvmName("vekurplgxdxkmlhb")
    public suspend fun subnetIds(vararg values: Output<String>) {
        this.subnetIds = Output.all(values.asList())
    }

    /**
     * @param values A list of VPC subnet IDs for the subnet group.
     */
    @JvmName("iydjxouvwjsqlvtv")
    public suspend fun subnetIds(values: List<Output<String>>) {
        this.subnetIds = Output.all(values)
    }

    /**
     * @param value A description of the subnet group.
     */
    @JvmName("qcvcahcspiooruuv")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The name of the subnet group.
     */
    @JvmName("fdhhqhonqsjkradb")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value A list of VPC subnet IDs for the subnet group.
     */
    @JvmName("ghbccwujprughbwo")
    public suspend fun subnetIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param values A list of VPC subnet IDs for the subnet group.
     */
    @JvmName("lixwcaeixplofdpv")
    public suspend fun subnetIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    internal fun build(): SubnetGroupArgs = SubnetGroupArgs(
        description = description,
        name = name,
        subnetIds = subnetIds,
    )
}
