@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.detective.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Graph].
 */
@PulumiTagMarker
public class GraphResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: GraphArgs = GraphArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend GraphArgsBuilder.() -> Unit) {
        val builder = GraphArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Graph {
        val builtJavaResource = com.pulumi.aws.detective.Graph(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Graph(builtJavaResource)
    }
}

/**
 * Provides a resource to manage an [AWS Detective Graph](https://docs.aws.amazon.com/detective/latest/APIReference/API_CreateGraph.html). As an AWS account may own only one Detective graph per region, provisioning multiple Detective graphs requires a separate provider configuration for each graph.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.detective.Graph;
 * import com.pulumi.aws.detective.GraphArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Graph("example", GraphArgs.builder()
 *             .tags(Map.of("Name", "example-detective-graph"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_detective_graph` using the ARN. For example:
 * ```sh
 *  $ pulumi import aws:detective/graph:Graph example arn:aws:detective:us-east-1:123456789101:graph:231684d34gh74g4bae1dbc7bd807d02d
 * ```
 *
 */
public class Graph internal constructor(
    override val javaResource: com.pulumi.aws.detective.Graph,
) : KotlinCustomResource(javaResource, GraphMapper) {
    /**
     * Date and time, in UTC and extended RFC 3339 format, when the Amazon Detective Graph was created.
     */
    public val createdTime: Output<String>
        get() = javaResource.createdTime().applyValue({ args0 -> args0 })

    /**
     * ARN of the Detective Graph.
     */
    public val graphArn: Output<String>
        get() = javaResource.graphArn().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the instance. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object GraphMapper : ResourceMapper<Graph> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.detective.Graph::class == javaResource::class

    override fun map(javaResource: Resource): Graph = Graph(
        javaResource as
            com.pulumi.aws.detective.Graph,
    )
}

/**
 * @see [Graph].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Graph].
 */
public suspend fun graph(name: String, block: suspend GraphResourceBuilder.() -> Unit): Graph {
    val builder = GraphResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Graph].
 * @param name The _unique_ name of the resulting resource.
 */
public fun graph(name: String): Graph {
    val builder = GraphResourceBuilder()
    builder.name(name)
    return builder.build()
}
