@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.detective.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [InvitationAccepter].
 */
@PulumiTagMarker
public class InvitationAccepterResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: InvitationAccepterArgs = InvitationAccepterArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend InvitationAccepterArgsBuilder.() -> Unit) {
        val builder = InvitationAccepterArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): InvitationAccepter {
        val builtJavaResource = com.pulumi.aws.detective.InvitationAccepter(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return InvitationAccepter(builtJavaResource)
    }
}

/**
 * Provides a resource to manage an [Amazon Detective Invitation Accepter](https://docs.aws.amazon.com/detective/latest/APIReference/API_AcceptInvitation.html). Ensure that the accepter is configured to use the AWS account you wish to _accept_ the invitation from the primary graph owner account.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.detective.Graph;
 * import com.pulumi.aws.detective.Member;
 * import com.pulumi.aws.detective.MemberArgs;
 * import com.pulumi.aws.detective.InvitationAccepter;
 * import com.pulumi.aws.detective.InvitationAccepterArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var primaryGraph = new Graph("primaryGraph");
 *         var primaryMember = new Member("primaryMember", MemberArgs.builder()
 *             .accountId("ACCOUNT ID")
 *             .emailAddress("EMAIL")
 *             .graphArn(primaryGraph.id())
 *             .message("Message of the invite")
 *             .build());
 *         var member = new InvitationAccepter("member", InvitationAccepterArgs.builder()
 *             .graphArn(primaryGraph.graphArn())
 *             .build(), CustomResourceOptions.builder()
 *                 .provider("awsalternate")
 *                 .dependsOn(primaryMember)
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_detective_invitation_accepter` using the graph ARN. For example:
 * ```sh
 *  $ pulumi import aws:detective/invitationAccepter:InvitationAccepter example arn:aws:detective:us-east-1:123456789101:graph:231684d34gh74g4bae1dbc7bd807d02d
 * ```
 *
 */
public class InvitationAccepter internal constructor(
    override val javaResource: com.pulumi.aws.detective.InvitationAccepter,
) : KotlinCustomResource(javaResource, InvitationAccepterMapper) {
    /**
     * ARN of the behavior graph that the member account is accepting the invitation for.
     */
    public val graphArn: Output<String>
        get() = javaResource.graphArn().applyValue({ args0 -> args0 })
}

public object InvitationAccepterMapper : ResourceMapper<InvitationAccepter> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.detective.InvitationAccepter::class == javaResource::class

    override fun map(javaResource: Resource): InvitationAccepter = InvitationAccepter(
        javaResource as
            com.pulumi.aws.detective.InvitationAccepter,
    )
}

/**
 * @see [InvitationAccepter].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [InvitationAccepter].
 */
public suspend fun invitationAccepter(
    name: String,
    block: suspend InvitationAccepterResourceBuilder.() -> Unit,
): InvitationAccepter {
    val builder = InvitationAccepterResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [InvitationAccepter].
 * @param name The _unique_ name of the resulting resource.
 */
public fun invitationAccepter(name: String): InvitationAccepter {
    val builder = InvitationAccepterResourceBuilder()
    builder.name(name)
    return builder.build()
}
