@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.detective.kotlin

import com.pulumi.aws.detective.InvitationAccepterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a resource to manage an [Amazon Detective Invitation Accepter](https://docs.aws.amazon.com/detective/latest/APIReference/API_AcceptInvitation.html). Ensure that the accepter is configured to use the AWS account you wish to _accept_ the invitation from the primary graph owner account.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.detective.Graph;
 * import com.pulumi.aws.detective.Member;
 * import com.pulumi.aws.detective.MemberArgs;
 * import com.pulumi.aws.detective.InvitationAccepter;
 * import com.pulumi.aws.detective.InvitationAccepterArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var primaryGraph = new Graph("primaryGraph");
 *         var primaryMember = new Member("primaryMember", MemberArgs.builder()
 *             .accountId("ACCOUNT ID")
 *             .emailAddress("EMAIL")
 *             .graphArn(primaryGraph.id())
 *             .message("Message of the invite")
 *             .build());
 *         var member = new InvitationAccepter("member", InvitationAccepterArgs.builder()
 *             .graphArn(primaryGraph.graphArn())
 *             .build(), CustomResourceOptions.builder()
 *                 .provider("awsalternate")
 *                 .dependsOn(primaryMember)
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_detective_invitation_accepter` using the graph ARN. For example:
 * ```sh
 *  $ pulumi import aws:detective/invitationAccepter:InvitationAccepter example arn:aws:detective:us-east-1:123456789101:graph:231684d34gh74g4bae1dbc7bd807d02d
 * ```
 * @property graphArn ARN of the behavior graph that the member account is accepting the invitation for.
 */
public data class InvitationAccepterArgs(
    public val graphArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.detective.InvitationAccepterArgs> {
    override fun toJava(): com.pulumi.aws.detective.InvitationAccepterArgs =
        com.pulumi.aws.detective.InvitationAccepterArgs.builder()
            .graphArn(graphArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InvitationAccepterArgs].
 */
@PulumiTagMarker
public class InvitationAccepterArgsBuilder internal constructor() {
    private var graphArn: Output<String>? = null

    /**
     * @param value ARN of the behavior graph that the member account is accepting the invitation for.
     */
    @JvmName("upackyamuyflocmh")
    public suspend fun graphArn(`value`: Output<String>) {
        this.graphArn = value
    }

    /**
     * @param value ARN of the behavior graph that the member account is accepting the invitation for.
     */
    @JvmName("ddcjjdpsgenqojbe")
    public suspend fun graphArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.graphArn = mapped
    }

    internal fun build(): InvitationAccepterArgs = InvitationAccepterArgs(
        graphArn = graphArn,
    )
}
