@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.detective.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Member].
 */
@PulumiTagMarker
public class MemberResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: MemberArgs = MemberArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend MemberArgsBuilder.() -> Unit) {
        val builder = MemberArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Member {
        val builtJavaResource = com.pulumi.aws.detective.Member(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Member(builtJavaResource)
    }
}

/**
 * Provides a resource to manage an [Amazon Detective Member](https://docs.aws.amazon.com/detective/latest/APIReference/API_CreateMembers.html).
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.detective.Graph;
 * import com.pulumi.aws.detective.Member;
 * import com.pulumi.aws.detective.MemberArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleGraph = new Graph("exampleGraph");
 *         var exampleMember = new Member("exampleMember", MemberArgs.builder()
 *             .accountId("AWS ACCOUNT ID")
 *             .emailAddress("EMAIL")
 *             .graphArn(exampleGraph.id())
 *             .message("Message of the invitation")
 *             .disableEmailNotification(true)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_detective_member` using the ARN of the graph followed by the account ID of the member account. For example:
 * ```sh
 *  $ pulumi import aws:detective/member:Member example arn:aws:detective:us-east-1:123456789101:graph:231684d34gh74g4bae1dbc7bd807d02d/123456789012
 * ```
 *
 */
public class Member internal constructor(
    override val javaResource: com.pulumi.aws.detective.Member,
) : KotlinCustomResource(javaResource, MemberMapper) {
    /**
     * AWS account ID for the account.
     */
    public val accountId: Output<String>
        get() = javaResource.accountId().applyValue({ args0 -> args0 })

    /**
     * AWS account ID for the administrator account.
     */
    public val administratorId: Output<String>
        get() = javaResource.administratorId().applyValue({ args0 -> args0 })

    /**
     * If set to true, then the root user of the invited account will _not_ receive an email notification. This notification is in addition to an alert that the root user receives in AWS Personal Health Dashboard. By default, this is set to `false`.
     */
    public val disableEmailNotification: Output<Boolean>?
        get() = javaResource.disableEmailNotification().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val disabledReason: Output<String>
        get() = javaResource.disabledReason().applyValue({ args0 -> args0 })

    /**
     * Email address for the account.
     */
    public val emailAddress: Output<String>
        get() = javaResource.emailAddress().applyValue({ args0 -> args0 })

    /**
     * ARN of the behavior graph to invite the member accounts to contribute their data to.
     */
    public val graphArn: Output<String>
        get() = javaResource.graphArn().applyValue({ args0 -> args0 })

    /**
     * Date and time, in UTC and extended RFC 3339 format, when an Amazon Detective membership invitation was last sent to the account.
     */
    public val invitedTime: Output<String>
        get() = javaResource.invitedTime().applyValue({ args0 -> args0 })

    /**
     * A custom message to include in the invitation. Amazon Detective adds this message to the standard content that it sends for an invitation.
     */
    public val message: Output<String>?
        get() = javaResource.message().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Current membership status of the member account.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Date and time, in UTC and extended RFC 3339 format, of the most recent change to the member account's status.
     */
    public val updatedTime: Output<String>
        get() = javaResource.updatedTime().applyValue({ args0 -> args0 })

    /**
     * Data volume in bytes per day for the member account.
     */
    public val volumeUsageInBytes: Output<String>
        get() = javaResource.volumeUsageInBytes().applyValue({ args0 -> args0 })
}

public object MemberMapper : ResourceMapper<Member> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.detective.Member::class == javaResource::class

    override fun map(javaResource: Resource): Member = Member(
        javaResource as
            com.pulumi.aws.detective.Member,
    )
}

/**
 * @see [Member].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Member].
 */
public suspend fun member(name: String, block: suspend MemberResourceBuilder.() -> Unit): Member {
    val builder = MemberResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Member].
 * @param name The _unique_ name of the resulting resource.
 */
public fun member(name: String): Member {
    val builder = MemberResourceBuilder()
    builder.name(name)
    return builder.build()
}
