@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.detective.kotlin

import com.pulumi.aws.detective.OrganizationAdminAccountArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Manages a Detective Organization Admin Account. The AWS account utilizing this resource must be an Organizations primary account. More information about Organizations support in Detective can be found in the [Detective User Guide](https://docs.aws.amazon.com/detective/latest/adminguide/accounts-orgs-transition.html).
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.organizations.Organization;
 * import com.pulumi.aws.organizations.OrganizationArgs;
 * import com.pulumi.aws.detective.OrganizationAdminAccount;
 * import com.pulumi.aws.detective.OrganizationAdminAccountArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleOrganization = new Organization("exampleOrganization", OrganizationArgs.builder()
 *             .awsServiceAccessPrincipals("detective.amazonaws.com")
 *             .featureSet("ALL")
 *             .build());
 *         var exampleOrganizationAdminAccount = new OrganizationAdminAccount("exampleOrganizationAdminAccount", OrganizationAdminAccountArgs.builder()
 *             .accountId("123456789012")
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleOrganization)
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_detective_organization_admin_account` using `account_id`. For example:
 * ```sh
 *  $ pulumi import aws:detective/organizationAdminAccount:OrganizationAdminAccount example 123456789012
 * ```
 * @property accountId AWS account identifier to designate as a delegated administrator for Detective.
 */
public data class OrganizationAdminAccountArgs(
    public val accountId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.detective.OrganizationAdminAccountArgs> {
    override fun toJava(): com.pulumi.aws.detective.OrganizationAdminAccountArgs =
        com.pulumi.aws.detective.OrganizationAdminAccountArgs.builder()
            .accountId(accountId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [OrganizationAdminAccountArgs].
 */
@PulumiTagMarker
public class OrganizationAdminAccountArgsBuilder internal constructor() {
    private var accountId: Output<String>? = null

    /**
     * @param value AWS account identifier to designate as a delegated administrator for Detective.
     */
    @JvmName("wmnrnqcjwkktkekg")
    public suspend fun accountId(`value`: Output<String>) {
        this.accountId = value
    }

    /**
     * @param value AWS account identifier to designate as a delegated administrator for Detective.
     */
    @JvmName("qknqoykhspumypgt")
    public suspend fun accountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountId = mapped
    }

    internal fun build(): OrganizationAdminAccountArgs = OrganizationAdminAccountArgs(
        accountId = accountId,
    )
}
