@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.detective.kotlin

import com.pulumi.aws.detective.OrganizationConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.detective.Graph;
 * import com.pulumi.aws.detective.GraphArgs;
 * import com.pulumi.aws.detective.OrganizationConfiguration;
 * import com.pulumi.aws.detective.OrganizationConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleGraph = new Graph("exampleGraph", GraphArgs.builder()
 *             .enable(true)
 *             .build());
 *         var exampleOrganizationConfiguration = new OrganizationConfiguration("exampleOrganizationConfiguration", OrganizationConfigurationArgs.builder()
 *             .autoEnable(true)
 *             .graphArn(exampleGraph.id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_detective_organization_admin_account` using the Detective Graph ID. For example:
 * ```sh
 *  $ pulumi import aws:detective/organizationConfiguration:OrganizationConfiguration example 00b00fd5aecc0ab60a708659477e9617
 * ```
 * @property autoEnable When this setting is enabled, all new accounts that are created in, or added to, the organization are added as a member accounts of the organization’s Detective delegated administrator and Detective is enabled in that AWS Region.
 * @property graphArn ARN of the behavior graph.
 */
public data class OrganizationConfigurationArgs(
    public val autoEnable: Output<Boolean>? = null,
    public val graphArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.detective.OrganizationConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.detective.OrganizationConfigurationArgs =
        com.pulumi.aws.detective.OrganizationConfigurationArgs.builder()
            .autoEnable(autoEnable?.applyValue({ args0 -> args0 }))
            .graphArn(graphArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [OrganizationConfigurationArgs].
 */
@PulumiTagMarker
public class OrganizationConfigurationArgsBuilder internal constructor() {
    private var autoEnable: Output<Boolean>? = null

    private var graphArn: Output<String>? = null

    /**
     * @param value When this setting is enabled, all new accounts that are created in, or added to, the organization are added as a member accounts of the organization’s Detective delegated administrator and Detective is enabled in that AWS Region.
     */
    @JvmName("jcbinfnnimijguqg")
    public suspend fun autoEnable(`value`: Output<Boolean>) {
        this.autoEnable = value
    }

    /**
     * @param value ARN of the behavior graph.
     */
    @JvmName("qlnqrouvnaqjgwgk")
    public suspend fun graphArn(`value`: Output<String>) {
        this.graphArn = value
    }

    /**
     * @param value When this setting is enabled, all new accounts that are created in, or added to, the organization are added as a member accounts of the organization’s Detective delegated administrator and Detective is enabled in that AWS Region.
     */
    @JvmName("dsujorwfahfogpin")
    public suspend fun autoEnable(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoEnable = mapped
    }

    /**
     * @param value ARN of the behavior graph.
     */
    @JvmName("nxcpljbvpannvsjb")
    public suspend fun graphArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.graphArn = mapped
    }

    internal fun build(): OrganizationConfigurationArgs = OrganizationConfigurationArgs(
        autoEnable = autoEnable,
        graphArn = graphArn,
    )
}
