@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.devicefarm.kotlin

import com.pulumi.aws.devicefarm.DevicePoolArgs.builder
import com.pulumi.aws.devicefarm.kotlin.inputs.DevicePoolRuleArgs
import com.pulumi.aws.devicefarm.kotlin.inputs.DevicePoolRuleArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a resource to manage AWS Device Farm Device Pools.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.devicefarm.DevicePool;
 * import com.pulumi.aws.devicefarm.DevicePoolArgs;
 * import com.pulumi.aws.devicefarm.inputs.DevicePoolRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DevicePool("example", DevicePoolArgs.builder()
 *             .projectArn(aws_devicefarm_project.example().arn())
 *             .rules(DevicePoolRuleArgs.builder()
 *                 .attribute("OS_VERSION")
 *                 .operator("EQUALS")
 *                 .value("\"AVAILABLE\"")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import DeviceFarm Device Pools using their ARN. For example:
 * ```sh
 *  $ pulumi import aws:devicefarm/devicePool:DevicePool example arn:aws:devicefarm:us-west-2:123456789012:devicepool:4fa784c7-ccb4-4dbf-ba4f-02198320daa1/4fa784c7-ccb4-4dbf-ba4f-02198320daa1
 * ```
 * @property description The device pool's description.
 * @property maxDevices The number of devices that Device Farm can add to your device pool.
 * @property name The name of the Device Pool
 * @property projectArn The ARN of the project for the device pool.
 * @property rules The device pool's rules. See Rule.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class DevicePoolArgs(
    public val description: Output<String>? = null,
    public val maxDevices: Output<Int>? = null,
    public val name: Output<String>? = null,
    public val projectArn: Output<String>? = null,
    public val rules: Output<List<DevicePoolRuleArgs>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.devicefarm.DevicePoolArgs> {
    override fun toJava(): com.pulumi.aws.devicefarm.DevicePoolArgs =
        com.pulumi.aws.devicefarm.DevicePoolArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .maxDevices(maxDevices?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .projectArn(projectArn?.applyValue({ args0 -> args0 }))
            .rules(rules?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [DevicePoolArgs].
 */
@PulumiTagMarker
public class DevicePoolArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var maxDevices: Output<Int>? = null

    private var name: Output<String>? = null

    private var projectArn: Output<String>? = null

    private var rules: Output<List<DevicePoolRuleArgs>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The device pool's description.
     */
    @JvmName("mqbbregpbmycrwwe")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The number of devices that Device Farm can add to your device pool.
     */
    @JvmName("tcfudqgdsmccjaui")
    public suspend fun maxDevices(`value`: Output<Int>) {
        this.maxDevices = value
    }

    /**
     * @param value The name of the Device Pool
     */
    @JvmName("hexesnotabalggre")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The ARN of the project for the device pool.
     */
    @JvmName("nggetogomvfmkgrn")
    public suspend fun projectArn(`value`: Output<String>) {
        this.projectArn = value
    }

    /**
     * @param value The device pool's rules. See Rule.
     */
    @JvmName("yclyflkooktyaklj")
    public suspend fun rules(`value`: Output<List<DevicePoolRuleArgs>>) {
        this.rules = value
    }

    @JvmName("sytnpiyuhuoftlkx")
    public suspend fun rules(vararg values: Output<DevicePoolRuleArgs>) {
        this.rules = Output.all(values.asList())
    }

    /**
     * @param values The device pool's rules. See Rule.
     */
    @JvmName("tknqlpikhmulsubb")
    public suspend fun rules(values: List<Output<DevicePoolRuleArgs>>) {
        this.rules = Output.all(values)
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("wpkvglvkquwbvfgo")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The device pool's description.
     */
    @JvmName("hcycduoxkefqsaqf")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The number of devices that Device Farm can add to your device pool.
     */
    @JvmName("yfwsdkjjtoocnahi")
    public suspend fun maxDevices(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxDevices = mapped
    }

    /**
     * @param value The name of the Device Pool
     */
    @JvmName("navwbxcnfxgtipvl")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The ARN of the project for the device pool.
     */
    @JvmName("ettcjvxbmadwyyrf")
    public suspend fun projectArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.projectArn = mapped
    }

    /**
     * @param value The device pool's rules. See Rule.
     */
    @JvmName("keipyuylqplukeuo")
    public suspend fun rules(`value`: List<DevicePoolRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    /**
     * @param argument The device pool's rules. See Rule.
     */
    @JvmName("xkgkribpcrtdajau")
    public suspend fun rules(argument: List<suspend DevicePoolRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DevicePoolRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param argument The device pool's rules. See Rule.
     */
    @JvmName("llbgidcaehtwvdrn")
    public suspend fun rules(vararg argument: suspend DevicePoolRuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DevicePoolRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param argument The device pool's rules. See Rule.
     */
    @JvmName("trrkkdkxhqauhdjh")
    public suspend fun rules(argument: suspend DevicePoolRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(DevicePoolRuleArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param values The device pool's rules. See Rule.
     */
    @JvmName("pnerkitynvoyliqi")
    public suspend fun rules(vararg values: DevicePoolRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("epafvvsyhcsvyumj")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("vmvkwnyrulhtlhls")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): DevicePoolArgs = DevicePoolArgs(
        description = description,
        maxDevices = maxDevices,
        name = name,
        projectArn = projectArn,
        rules = rules,
        tags = tags,
    )
}
