@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.devicefarm.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [InstanceProfile].
 */
@PulumiTagMarker
public class InstanceProfileResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: InstanceProfileArgs = InstanceProfileArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend InstanceProfileArgsBuilder.() -> Unit) {
        val builder = InstanceProfileArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): InstanceProfile {
        val builtJavaResource = com.pulumi.aws.devicefarm.InstanceProfile(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return InstanceProfile(builtJavaResource)
    }
}

/**
 * Provides a resource to manage AWS Device Farm Instance Profiles.
 * ∂
 * > **NOTE:** AWS currently has limited regional support for Device Farm (e.g., `us-west-2`). See [AWS Device Farm endpoints and quotas](https://docs.aws.amazon.com/general/latest/gr/devicefarm.html) for information on supported regions.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.devicefarm.InstanceProfile;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new InstanceProfile("example");
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import DeviceFarm Instance Profiles using their ARN. For example:
 * ```sh
 *  $ pulumi import aws:devicefarm/instanceProfile:InstanceProfile example arn:aws:devicefarm:us-west-2:123456789012:instanceprofile:4fa784c7-ccb4-4dbf-ba4f-02198320daa1
 * ```
 *
 */
public class InstanceProfile internal constructor(
    override val javaResource: com.pulumi.aws.devicefarm.InstanceProfile,
) : KotlinCustomResource(javaResource, InstanceProfileMapper) {
    /**
     * The Amazon Resource Name of this instance profile.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The description of the instance profile.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * An array of strings that specifies the list of app packages that should not be cleaned up from the device after a test run.
     */
    public val excludeAppPackagesFromCleanups: Output<List<String>>?
        get() = javaResource.excludeAppPackagesFromCleanups().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The name for the instance profile.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * When set to `true`, Device Farm removes app packages after a test run. The default value is `false` for private devices.
     */
    public val packageCleanup: Output<Boolean>?
        get() = javaResource.packageCleanup().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * When set to `true`, Device Farm reboots the instance after a test run. The default value is `true`.
     */
    public val rebootAfterUse: Output<Boolean>?
        get() = javaResource.rebootAfterUse().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object InstanceProfileMapper : ResourceMapper<InstanceProfile> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.devicefarm.InstanceProfile::class == javaResource::class

    override fun map(javaResource: Resource): InstanceProfile = InstanceProfile(
        javaResource as
            com.pulumi.aws.devicefarm.InstanceProfile,
    )
}

/**
 * @see [InstanceProfile].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [InstanceProfile].
 */
public suspend fun instanceProfile(
    name: String,
    block: suspend InstanceProfileResourceBuilder.() -> Unit,
): InstanceProfile {
    val builder = InstanceProfileResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [InstanceProfile].
 * @param name The _unique_ name of the resulting resource.
 */
public fun instanceProfile(name: String): InstanceProfile {
    val builder = InstanceProfileResourceBuilder()
    builder.name(name)
    return builder.build()
}
