@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.devicefarm.kotlin

import com.pulumi.aws.devicefarm.InstanceProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a resource to manage AWS Device Farm Instance Profiles.
 * ∂
 * > **NOTE:** AWS currently has limited regional support for Device Farm (e.g., `us-west-2`). See [AWS Device Farm endpoints and quotas](https://docs.aws.amazon.com/general/latest/gr/devicefarm.html) for information on supported regions.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.devicefarm.InstanceProfile;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new InstanceProfile("example");
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import DeviceFarm Instance Profiles using their ARN. For example:
 * ```sh
 *  $ pulumi import aws:devicefarm/instanceProfile:InstanceProfile example arn:aws:devicefarm:us-west-2:123456789012:instanceprofile:4fa784c7-ccb4-4dbf-ba4f-02198320daa1
 * ```
 * @property description The description of the instance profile.
 * @property excludeAppPackagesFromCleanups An array of strings that specifies the list of app packages that should not be cleaned up from the device after a test run.
 * @property name The name for the instance profile.
 * @property packageCleanup When set to `true`, Device Farm removes app packages after a test run. The default value is `false` for private devices.
 * @property rebootAfterUse When set to `true`, Device Farm reboots the instance after a test run. The default value is `true`.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class InstanceProfileArgs(
    public val description: Output<String>? = null,
    public val excludeAppPackagesFromCleanups: Output<List<String>>? = null,
    public val name: Output<String>? = null,
    public val packageCleanup: Output<Boolean>? = null,
    public val rebootAfterUse: Output<Boolean>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.devicefarm.InstanceProfileArgs> {
    override fun toJava(): com.pulumi.aws.devicefarm.InstanceProfileArgs =
        com.pulumi.aws.devicefarm.InstanceProfileArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .excludeAppPackagesFromCleanups(
                excludeAppPackagesFromCleanups?.applyValue({ args0 ->
                    args0.map({ args0 -> args0 })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .packageCleanup(packageCleanup?.applyValue({ args0 -> args0 }))
            .rebootAfterUse(rebootAfterUse?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [InstanceProfileArgs].
 */
@PulumiTagMarker
public class InstanceProfileArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var excludeAppPackagesFromCleanups: Output<List<String>>? = null

    private var name: Output<String>? = null

    private var packageCleanup: Output<Boolean>? = null

    private var rebootAfterUse: Output<Boolean>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The description of the instance profile.
     */
    @JvmName("xlerjadeiolkiehj")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value An array of strings that specifies the list of app packages that should not be cleaned up from the device after a test run.
     */
    @JvmName("yxfdhgmwsrabrxyh")
    public suspend fun excludeAppPackagesFromCleanups(`value`: Output<List<String>>) {
        this.excludeAppPackagesFromCleanups = value
    }

    @JvmName("hrxundofjiucbkvp")
    public suspend fun excludeAppPackagesFromCleanups(vararg values: Output<String>) {
        this.excludeAppPackagesFromCleanups = Output.all(values.asList())
    }

    /**
     * @param values An array of strings that specifies the list of app packages that should not be cleaned up from the device after a test run.
     */
    @JvmName("ysxordiambjhygni")
    public suspend fun excludeAppPackagesFromCleanups(values: List<Output<String>>) {
        this.excludeAppPackagesFromCleanups = Output.all(values)
    }

    /**
     * @param value The name for the instance profile.
     */
    @JvmName("grlobnxkjrikodlf")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value When set to `true`, Device Farm removes app packages after a test run. The default value is `false` for private devices.
     */
    @JvmName("kmrdmqbhuwxkiqsi")
    public suspend fun packageCleanup(`value`: Output<Boolean>) {
        this.packageCleanup = value
    }

    /**
     * @param value When set to `true`, Device Farm reboots the instance after a test run. The default value is `true`.
     */
    @JvmName("kaodovbhqeyaxaxs")
    public suspend fun rebootAfterUse(`value`: Output<Boolean>) {
        this.rebootAfterUse = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("agcgmjeayvqcixnc")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The description of the instance profile.
     */
    @JvmName("iibqcugitbadmseh")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value An array of strings that specifies the list of app packages that should not be cleaned up from the device after a test run.
     */
    @JvmName("wxvyaegifpioehqb")
    public suspend fun excludeAppPackagesFromCleanups(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.excludeAppPackagesFromCleanups = mapped
    }

    /**
     * @param values An array of strings that specifies the list of app packages that should not be cleaned up from the device after a test run.
     */
    @JvmName("fpntochughwjvioo")
    public suspend fun excludeAppPackagesFromCleanups(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.excludeAppPackagesFromCleanups = mapped
    }

    /**
     * @param value The name for the instance profile.
     */
    @JvmName("snossmktfmuvrirc")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value When set to `true`, Device Farm removes app packages after a test run. The default value is `false` for private devices.
     */
    @JvmName("bfpsqvlklropwrfa")
    public suspend fun packageCleanup(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.packageCleanup = mapped
    }

    /**
     * @param value When set to `true`, Device Farm reboots the instance after a test run. The default value is `true`.
     */
    @JvmName("occodqarpidlceic")
    public suspend fun rebootAfterUse(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rebootAfterUse = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("sojtrukvqgwcwhty")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("tpcnpttmnmfkfrjt")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): InstanceProfileArgs = InstanceProfileArgs(
        description = description,
        excludeAppPackagesFromCleanups = excludeAppPackagesFromCleanups,
        name = name,
        packageCleanup = packageCleanup,
        rebootAfterUse = rebootAfterUse,
        tags = tags,
    )
}
