@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.devicefarm.kotlin

import com.pulumi.aws.devicefarm.TestGridProjectArgs.builder
import com.pulumi.aws.devicefarm.kotlin.inputs.TestGridProjectVpcConfigArgs
import com.pulumi.aws.devicefarm.kotlin.inputs.TestGridProjectVpcConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a resource to manage AWS Device Farm Test Grid Projects.
 * > **NOTE:** AWS currently has limited regional support for Device Farm (e.g., `us-west-2`). See [AWS Device Farm endpoints and quotas](https://docs.aws.amazon.com/general/latest/gr/devicefarm.html) for information on supported regions.
 * ## Import
 * Using `pulumi import`, import DeviceFarm Test Grid Projects using their ARN. For example:
 * ```sh
 *  $ pulumi import aws:devicefarm/testGridProject:TestGridProject example arn:aws:devicefarm:us-west-2:123456789012:testgrid-project:4fa784c7-ccb4-4dbf-ba4f-02198320daa1
 * ```
 * @property description Human-readable description of the project.
 * @property name The name of the Selenium testing project.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property vpcConfig The VPC security groups and subnets that are attached to a project. See VPC Config below.
 */
public data class TestGridProjectArgs(
    public val description: Output<String>? = null,
    public val name: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vpcConfig: Output<TestGridProjectVpcConfigArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.devicefarm.TestGridProjectArgs> {
    override fun toJava(): com.pulumi.aws.devicefarm.TestGridProjectArgs =
        com.pulumi.aws.devicefarm.TestGridProjectArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vpcConfig(vpcConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [TestGridProjectArgs].
 */
@PulumiTagMarker
public class TestGridProjectArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var name: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vpcConfig: Output<TestGridProjectVpcConfigArgs>? = null

    /**
     * @param value Human-readable description of the project.
     */
    @JvmName("xflrepqypohiwjbr")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The name of the Selenium testing project.
     */
    @JvmName("nbmpriqqayeyrgfc")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("eurjhvyhgiycqtyc")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The VPC security groups and subnets that are attached to a project. See VPC Config below.
     */
    @JvmName("xnnfjexnefkefdjd")
    public suspend fun vpcConfig(`value`: Output<TestGridProjectVpcConfigArgs>) {
        this.vpcConfig = value
    }

    /**
     * @param value Human-readable description of the project.
     */
    @JvmName("hgbublbawfgeqtjr")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The name of the Selenium testing project.
     */
    @JvmName("yclepksvfhpqwjft")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("uamjbnhtavfpttpw")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("tjywgxjbaqgwoahh")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The VPC security groups and subnets that are attached to a project. See VPC Config below.
     */
    @JvmName("bmmacggneiwwbjep")
    public suspend fun vpcConfig(`value`: TestGridProjectVpcConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcConfig = mapped
    }

    /**
     * @param argument The VPC security groups and subnets that are attached to a project. See VPC Config below.
     */
    @JvmName("dqbxcpolmvhunfte")
    public suspend fun vpcConfig(argument: suspend TestGridProjectVpcConfigArgsBuilder.() -> Unit) {
        val toBeMapped = TestGridProjectVpcConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.vpcConfig = mapped
    }

    internal fun build(): TestGridProjectArgs = TestGridProjectArgs(
        description = description,
        name = name,
        tags = tags,
        vpcConfig = vpcConfig,
    )
}
