@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.devicefarm.kotlin

import com.pulumi.aws.devicefarm.UploadArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a resource to manage AWS Device Farm Uploads.
 * > **NOTE:** AWS currently has limited regional support for Device Farm (e.g., `us-west-2`). See [AWS Device Farm endpoints and quotas](https://docs.aws.amazon.com/general/latest/gr/devicefarm.html) for information on supported regions.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.devicefarm.Project;
 * import com.pulumi.aws.devicefarm.Upload;
 * import com.pulumi.aws.devicefarm.UploadArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleProject = new Project("exampleProject");
 *         var exampleUpload = new Upload("exampleUpload", UploadArgs.builder()
 *             .projectArn(exampleProject.arn())
 *             .type("APPIUM_JAVA_TESTNG_TEST_SPEC")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import DeviceFarm Uploads using their ARN. For example:
 * ```sh
 *  $ pulumi import aws:devicefarm/upload:Upload example arn:aws:devicefarm:us-west-2:123456789012:upload:4fa784c7-ccb4-4dbf-ba4f-02198320daa1
 * ```
 * @property contentType The upload's content type (for example, application/octet-stream).
 * @property name The upload's file name. The name should not contain any forward slashes (/). If you are uploading an iOS app, the file name must end with the .ipa extension. If you are uploading an Android app, the file name must end with the .apk extension. For all others, the file name must end with the .zip file extension.
 * @property projectArn The ARN of the project for the upload.
 * @property type The upload's upload type. See [AWS Docs](https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_CreateUpload.html#API_CreateUpload_RequestSyntax) for valid list of values.
 */
public data class UploadArgs(
    public val contentType: Output<String>? = null,
    public val name: Output<String>? = null,
    public val projectArn: Output<String>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.devicefarm.UploadArgs> {
    override fun toJava(): com.pulumi.aws.devicefarm.UploadArgs =
        com.pulumi.aws.devicefarm.UploadArgs.builder()
            .contentType(contentType?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .projectArn(projectArn?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UploadArgs].
 */
@PulumiTagMarker
public class UploadArgsBuilder internal constructor() {
    private var contentType: Output<String>? = null

    private var name: Output<String>? = null

    private var projectArn: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value The upload's content type (for example, application/octet-stream).
     */
    @JvmName("cphmmqxolkgvkyrm")
    public suspend fun contentType(`value`: Output<String>) {
        this.contentType = value
    }

    /**
     * @param value The upload's file name. The name should not contain any forward slashes (/). If you are uploading an iOS app, the file name must end with the .ipa extension. If you are uploading an Android app, the file name must end with the .apk extension. For all others, the file name must end with the .zip file extension.
     */
    @JvmName("bbqawectheppvutj")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The ARN of the project for the upload.
     */
    @JvmName("swamyhvhjkxwhiex")
    public suspend fun projectArn(`value`: Output<String>) {
        this.projectArn = value
    }

    /**
     * @param value The upload's upload type. See [AWS Docs](https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_CreateUpload.html#API_CreateUpload_RequestSyntax) for valid list of values.
     */
    @JvmName("tmfobcvggrngrtim")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The upload's content type (for example, application/octet-stream).
     */
    @JvmName("iqfhhwunbxhxmaus")
    public suspend fun contentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contentType = mapped
    }

    /**
     * @param value The upload's file name. The name should not contain any forward slashes (/). If you are uploading an iOS app, the file name must end with the .ipa extension. If you are uploading an Android app, the file name must end with the .apk extension. For all others, the file name must end with the .zip file extension.
     */
    @JvmName("oadraicselrfvyog")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The ARN of the project for the upload.
     */
    @JvmName("pyonqkupdxfxdlxo")
    public suspend fun projectArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.projectArn = mapped
    }

    /**
     * @param value The upload's upload type. See [AWS Docs](https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_CreateUpload.html#API_CreateUpload_RequestSyntax) for valid list of values.
     */
    @JvmName("blxhsmihrsypnncj")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): UploadArgs = UploadArgs(
        contentType = contentType,
        name = name,
        projectArn = projectArn,
        type = type,
    )
}
