@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.devicefarm.kotlin.inputs

import com.pulumi.aws.devicefarm.inputs.TestGridProjectVpcConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property securityGroupIds A list of VPC security group IDs in your Amazon VPC.
 * @property subnetIds A list of VPC subnet IDs in your Amazon VPC.
 * @property vpcId The ID of the Amazon VPC.
 */
public data class TestGridProjectVpcConfigArgs(
    public val securityGroupIds: Output<List<String>>,
    public val subnetIds: Output<List<String>>,
    public val vpcId: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.devicefarm.inputs.TestGridProjectVpcConfigArgs> {
    override fun toJava(): com.pulumi.aws.devicefarm.inputs.TestGridProjectVpcConfigArgs =
        com.pulumi.aws.devicefarm.inputs.TestGridProjectVpcConfigArgs.builder()
            .securityGroupIds(securityGroupIds.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .subnetIds(subnetIds.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .vpcId(vpcId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TestGridProjectVpcConfigArgs].
 */
@PulumiTagMarker
public class TestGridProjectVpcConfigArgsBuilder internal constructor() {
    private var securityGroupIds: Output<List<String>>? = null

    private var subnetIds: Output<List<String>>? = null

    private var vpcId: Output<String>? = null

    /**
     * @param value A list of VPC security group IDs in your Amazon VPC.
     */
    @JvmName("xxicmnubfrtpaesj")
    public suspend fun securityGroupIds(`value`: Output<List<String>>) {
        this.securityGroupIds = value
    }

    @JvmName("eaiponurpnyhqcig")
    public suspend fun securityGroupIds(vararg values: Output<String>) {
        this.securityGroupIds = Output.all(values.asList())
    }

    /**
     * @param values A list of VPC security group IDs in your Amazon VPC.
     */
    @JvmName("otrhftyvixuuepuc")
    public suspend fun securityGroupIds(values: List<Output<String>>) {
        this.securityGroupIds = Output.all(values)
    }

    /**
     * @param value A list of VPC subnet IDs in your Amazon VPC.
     */
    @JvmName("tdyypmbwhngxgmii")
    public suspend fun subnetIds(`value`: Output<List<String>>) {
        this.subnetIds = value
    }

    @JvmName("iyeiwloigfkbyedo")
    public suspend fun subnetIds(vararg values: Output<String>) {
        this.subnetIds = Output.all(values.asList())
    }

    /**
     * @param values A list of VPC subnet IDs in your Amazon VPC.
     */
    @JvmName("ykdbmxvgwgnfgtfl")
    public suspend fun subnetIds(values: List<Output<String>>) {
        this.subnetIds = Output.all(values)
    }

    /**
     * @param value The ID of the Amazon VPC.
     */
    @JvmName("sqfeknovgmdqremk")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value A list of VPC security group IDs in your Amazon VPC.
     */
    @JvmName("liyrigmahkcfdkdl")
    public suspend fun securityGroupIds(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param values A list of VPC security group IDs in your Amazon VPC.
     */
    @JvmName("njijrmectqadojby")
    public suspend fun securityGroupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param value A list of VPC subnet IDs in your Amazon VPC.
     */
    @JvmName("pposmfumtfrbsgjb")
    public suspend fun subnetIds(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param values A list of VPC subnet IDs in your Amazon VPC.
     */
    @JvmName("yfsgomnmplbrwyrt")
    public suspend fun subnetIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param value The ID of the Amazon VPC.
     */
    @JvmName("lgfucpslxlvuxotj")
    public suspend fun vpcId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    internal fun build(): TestGridProjectVpcConfigArgs = TestGridProjectVpcConfigArgs(
        securityGroupIds = securityGroupIds ?: throw PulumiNullFieldException("securityGroupIds"),
        subnetIds = subnetIds ?: throw PulumiNullFieldException("subnetIds"),
        vpcId = vpcId ?: throw PulumiNullFieldException("vpcId"),
    )
}
