@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.directconnect.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [BgpPeer].
 */
@PulumiTagMarker
public class BgpPeerResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BgpPeerArgs = BgpPeerArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BgpPeerArgsBuilder.() -> Unit) {
        val builder = BgpPeerArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): BgpPeer {
        val builtJavaResource = com.pulumi.aws.directconnect.BgpPeer(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return BgpPeer(builtJavaResource)
    }
}

/**
 * Provides a Direct Connect BGP peer resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.directconnect.BgpPeer;
 * import com.pulumi.aws.directconnect.BgpPeerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var peer = new BgpPeer("peer", BgpPeerArgs.builder()
 *             .virtualInterfaceId(aws_dx_private_virtual_interface.foo().id())
 *             .addressFamily("ipv6")
 *             .bgpAsn(65351)
 *             .build());
 *     }
 * }
 * ```
 */
public class BgpPeer internal constructor(
    override val javaResource: com.pulumi.aws.directconnect.BgpPeer,
) : KotlinCustomResource(javaResource, BgpPeerMapper) {
    /**
     * The address family for the BGP peer. `ipv4 ` or `ipv6`.
     */
    public val addressFamily: Output<String>
        get() = javaResource.addressFamily().applyValue({ args0 -> args0 })

    /**
     * The IPv4 CIDR address to use to send traffic to Amazon.
     * Required for IPv4 BGP peers on public virtual interfaces.
     */
    public val amazonAddress: Output<String>
        get() = javaResource.amazonAddress().applyValue({ args0 -> args0 })

    /**
     * The Direct Connect endpoint on which the BGP peer terminates.
     */
    public val awsDevice: Output<String>
        get() = javaResource.awsDevice().applyValue({ args0 -> args0 })

    /**
     * The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.
     */
    public val bgpAsn: Output<Int>
        get() = javaResource.bgpAsn().applyValue({ args0 -> args0 })

    /**
     * The authentication key for BGP configuration.
     */
    public val bgpAuthKey: Output<String>
        get() = javaResource.bgpAuthKey().applyValue({ args0 -> args0 })

    /**
     * The ID of the BGP peer.
     */
    public val bgpPeerId: Output<String>
        get() = javaResource.bgpPeerId().applyValue({ args0 -> args0 })

    /**
     * The Up/Down state of the BGP peer.
     */
    public val bgpStatus: Output<String>
        get() = javaResource.bgpStatus().applyValue({ args0 -> args0 })

    /**
     * The IPv4 CIDR destination address to which Amazon should send traffic.
     * Required for IPv4 BGP peers on public virtual interfaces.
     */
    public val customerAddress: Output<String>
        get() = javaResource.customerAddress().applyValue({ args0 -> args0 })

    /**
     * The ID of the Direct Connect virtual interface on which to create the BGP peer.
     */
    public val virtualInterfaceId: Output<String>
        get() = javaResource.virtualInterfaceId().applyValue({ args0 -> args0 })
}

public object BgpPeerMapper : ResourceMapper<BgpPeer> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.directconnect.BgpPeer::class == javaResource::class

    override fun map(javaResource: Resource): BgpPeer = BgpPeer(
        javaResource as
            com.pulumi.aws.directconnect.BgpPeer,
    )
}

/**
 * @see [BgpPeer].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [BgpPeer].
 */
public suspend fun bgpPeer(name: String, block: suspend BgpPeerResourceBuilder.() -> Unit):
    BgpPeer {
    val builder = BgpPeerResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [BgpPeer].
 * @param name The _unique_ name of the resulting resource.
 */
public fun bgpPeer(name: String): BgpPeer {
    val builder = BgpPeerResourceBuilder()
    builder.name(name)
    return builder.build()
}
