@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.directconnect.kotlin

import com.pulumi.aws.directconnect.BgpPeerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Direct Connect BGP peer resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.directconnect.BgpPeer;
 * import com.pulumi.aws.directconnect.BgpPeerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var peer = new BgpPeer("peer", BgpPeerArgs.builder()
 *             .virtualInterfaceId(aws_dx_private_virtual_interface.foo().id())
 *             .addressFamily("ipv6")
 *             .bgpAsn(65351)
 *             .build());
 *     }
 * }
 * ```
 * @property addressFamily The address family for the BGP peer. `ipv4 ` or `ipv6`.
 * @property amazonAddress The IPv4 CIDR address to use to send traffic to Amazon.
 * Required for IPv4 BGP peers on public virtual interfaces.
 * @property bgpAsn The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.
 * @property bgpAuthKey The authentication key for BGP configuration.
 * @property customerAddress The IPv4 CIDR destination address to which Amazon should send traffic.
 * Required for IPv4 BGP peers on public virtual interfaces.
 * @property virtualInterfaceId The ID of the Direct Connect virtual interface on which to create the BGP peer.
 */
public data class BgpPeerArgs(
    public val addressFamily: Output<String>? = null,
    public val amazonAddress: Output<String>? = null,
    public val bgpAsn: Output<Int>? = null,
    public val bgpAuthKey: Output<String>? = null,
    public val customerAddress: Output<String>? = null,
    public val virtualInterfaceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.directconnect.BgpPeerArgs> {
    override fun toJava(): com.pulumi.aws.directconnect.BgpPeerArgs =
        com.pulumi.aws.directconnect.BgpPeerArgs.builder()
            .addressFamily(addressFamily?.applyValue({ args0 -> args0 }))
            .amazonAddress(amazonAddress?.applyValue({ args0 -> args0 }))
            .bgpAsn(bgpAsn?.applyValue({ args0 -> args0 }))
            .bgpAuthKey(bgpAuthKey?.applyValue({ args0 -> args0 }))
            .customerAddress(customerAddress?.applyValue({ args0 -> args0 }))
            .virtualInterfaceId(virtualInterfaceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BgpPeerArgs].
 */
@PulumiTagMarker
public class BgpPeerArgsBuilder internal constructor() {
    private var addressFamily: Output<String>? = null

    private var amazonAddress: Output<String>? = null

    private var bgpAsn: Output<Int>? = null

    private var bgpAuthKey: Output<String>? = null

    private var customerAddress: Output<String>? = null

    private var virtualInterfaceId: Output<String>? = null

    /**
     * @param value The address family for the BGP peer. `ipv4 ` or `ipv6`.
     */
    @JvmName("bkrdbuivfanryvsf")
    public suspend fun addressFamily(`value`: Output<String>) {
        this.addressFamily = value
    }

    /**
     * @param value The IPv4 CIDR address to use to send traffic to Amazon.
     * Required for IPv4 BGP peers on public virtual interfaces.
     */
    @JvmName("mixrrmlrwjgjtkew")
    public suspend fun amazonAddress(`value`: Output<String>) {
        this.amazonAddress = value
    }

    /**
     * @param value The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.
     */
    @JvmName("pwfhdxfbbvpgswjr")
    public suspend fun bgpAsn(`value`: Output<Int>) {
        this.bgpAsn = value
    }

    /**
     * @param value The authentication key for BGP configuration.
     */
    @JvmName("hftxgeacqxnchnlt")
    public suspend fun bgpAuthKey(`value`: Output<String>) {
        this.bgpAuthKey = value
    }

    /**
     * @param value The IPv4 CIDR destination address to which Amazon should send traffic.
     * Required for IPv4 BGP peers on public virtual interfaces.
     */
    @JvmName("ftntukowjnsmmxsc")
    public suspend fun customerAddress(`value`: Output<String>) {
        this.customerAddress = value
    }

    /**
     * @param value The ID of the Direct Connect virtual interface on which to create the BGP peer.
     */
    @JvmName("vllybodbbmhjsppx")
    public suspend fun virtualInterfaceId(`value`: Output<String>) {
        this.virtualInterfaceId = value
    }

    /**
     * @param value The address family for the BGP peer. `ipv4 ` or `ipv6`.
     */
    @JvmName("svvcewwuemnouute")
    public suspend fun addressFamily(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.addressFamily = mapped
    }

    /**
     * @param value The IPv4 CIDR address to use to send traffic to Amazon.
     * Required for IPv4 BGP peers on public virtual interfaces.
     */
    @JvmName("segvvslsfxflkatq")
    public suspend fun amazonAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.amazonAddress = mapped
    }

    /**
     * @param value The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.
     */
    @JvmName("dycurereemtwbkom")
    public suspend fun bgpAsn(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bgpAsn = mapped
    }

    /**
     * @param value The authentication key for BGP configuration.
     */
    @JvmName("qqwnddfsvvsjqdgi")
    public suspend fun bgpAuthKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bgpAuthKey = mapped
    }

    /**
     * @param value The IPv4 CIDR destination address to which Amazon should send traffic.
     * Required for IPv4 BGP peers on public virtual interfaces.
     */
    @JvmName("rfnaejscakyygmkg")
    public suspend fun customerAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customerAddress = mapped
    }

    /**
     * @param value The ID of the Direct Connect virtual interface on which to create the BGP peer.
     */
    @JvmName("kxvntisgudfhbtdy")
    public suspend fun virtualInterfaceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualInterfaceId = mapped
    }

    internal fun build(): BgpPeerArgs = BgpPeerArgs(
        addressFamily = addressFamily,
        amazonAddress = amazonAddress,
        bgpAsn = bgpAsn,
        bgpAuthKey = bgpAuthKey,
        customerAddress = customerAddress,
        virtualInterfaceId = virtualInterfaceId,
    )
}
