@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.directconnect.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ConnectionAssociation].
 */
@PulumiTagMarker
public class ConnectionAssociationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ConnectionAssociationArgs = ConnectionAssociationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ConnectionAssociationArgsBuilder.() -> Unit) {
        val builder = ConnectionAssociationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ConnectionAssociation {
        val builtJavaResource =
            com.pulumi.aws.directconnect.ConnectionAssociation(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ConnectionAssociation(builtJavaResource)
    }
}

/**
 * Associates a Direct Connect Connection with a LAG.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.directconnect.Connection;
 * import com.pulumi.aws.directconnect.ConnectionArgs;
 * import com.pulumi.aws.directconnect.LinkAggregationGroup;
 * import com.pulumi.aws.directconnect.LinkAggregationGroupArgs;
 * import com.pulumi.aws.directconnect.ConnectionAssociation;
 * import com.pulumi.aws.directconnect.ConnectionAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleConnection = new Connection("exampleConnection", ConnectionArgs.builder()
 *             .bandwidth("1Gbps")
 *             .location("EqSe2-EQ")
 *             .build());
 *         var exampleLinkAggregationGroup = new LinkAggregationGroup("exampleLinkAggregationGroup", LinkAggregationGroupArgs.builder()
 *             .connectionsBandwidth("1Gbps")
 *             .location("EqSe2-EQ")
 *             .build());
 *         var exampleConnectionAssociation = new ConnectionAssociation("exampleConnectionAssociation", ConnectionAssociationArgs.builder()
 *             .connectionId(exampleConnection.id())
 *             .lagId(exampleLinkAggregationGroup.id())
 *             .build());
 *     }
 * }
 * ```
 */
public class ConnectionAssociation internal constructor(
    override val javaResource: com.pulumi.aws.directconnect.ConnectionAssociation,
) : KotlinCustomResource(javaResource, ConnectionAssociationMapper) {
    /**
     * The ID of the connection.
     */
    public val connectionId: Output<String>
        get() = javaResource.connectionId().applyValue({ args0 -> args0 })

    /**
     * The ID of the LAG with which to associate the connection.
     */
    public val lagId: Output<String>
        get() = javaResource.lagId().applyValue({ args0 -> args0 })
}

public object ConnectionAssociationMapper : ResourceMapper<ConnectionAssociation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.directconnect.ConnectionAssociation::class == javaResource::class

    override fun map(javaResource: Resource): ConnectionAssociation =
        ConnectionAssociation(javaResource as com.pulumi.aws.directconnect.ConnectionAssociation)
}

/**
 * @see [ConnectionAssociation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ConnectionAssociation].
 */
public suspend fun connectionAssociation(
    name: String,
    block: suspend ConnectionAssociationResourceBuilder.() -> Unit,
): ConnectionAssociation {
    val builder = ConnectionAssociationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ConnectionAssociation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun connectionAssociation(name: String): ConnectionAssociation {
    val builder = ConnectionAssociationResourceBuilder()
    builder.name(name)
    return builder.build()
}
