@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.directconnect.kotlin

import com.pulumi.aws.directconnect.ConnectionAssociationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Associates a Direct Connect Connection with a LAG.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.directconnect.Connection;
 * import com.pulumi.aws.directconnect.ConnectionArgs;
 * import com.pulumi.aws.directconnect.LinkAggregationGroup;
 * import com.pulumi.aws.directconnect.LinkAggregationGroupArgs;
 * import com.pulumi.aws.directconnect.ConnectionAssociation;
 * import com.pulumi.aws.directconnect.ConnectionAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleConnection = new Connection("exampleConnection", ConnectionArgs.builder()
 *             .bandwidth("1Gbps")
 *             .location("EqSe2-EQ")
 *             .build());
 *         var exampleLinkAggregationGroup = new LinkAggregationGroup("exampleLinkAggregationGroup", LinkAggregationGroupArgs.builder()
 *             .connectionsBandwidth("1Gbps")
 *             .location("EqSe2-EQ")
 *             .build());
 *         var exampleConnectionAssociation = new ConnectionAssociation("exampleConnectionAssociation", ConnectionAssociationArgs.builder()
 *             .connectionId(exampleConnection.id())
 *             .lagId(exampleLinkAggregationGroup.id())
 *             .build());
 *     }
 * }
 * ```
 * @property connectionId The ID of the connection.
 * @property lagId The ID of the LAG with which to associate the connection.
 */
public data class ConnectionAssociationArgs(
    public val connectionId: Output<String>? = null,
    public val lagId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.directconnect.ConnectionAssociationArgs> {
    override fun toJava(): com.pulumi.aws.directconnect.ConnectionAssociationArgs =
        com.pulumi.aws.directconnect.ConnectionAssociationArgs.builder()
            .connectionId(connectionId?.applyValue({ args0 -> args0 }))
            .lagId(lagId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConnectionAssociationArgs].
 */
@PulumiTagMarker
public class ConnectionAssociationArgsBuilder internal constructor() {
    private var connectionId: Output<String>? = null

    private var lagId: Output<String>? = null

    /**
     * @param value The ID of the connection.
     */
    @JvmName("wcvneubeldanwvyq")
    public suspend fun connectionId(`value`: Output<String>) {
        this.connectionId = value
    }

    /**
     * @param value The ID of the LAG with which to associate the connection.
     */
    @JvmName("ptrfkpmhaaxwtutu")
    public suspend fun lagId(`value`: Output<String>) {
        this.lagId = value
    }

    /**
     * @param value The ID of the connection.
     */
    @JvmName("eqtibhjykfcwccir")
    public suspend fun connectionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionId = mapped
    }

    /**
     * @param value The ID of the LAG with which to associate the connection.
     */
    @JvmName("icbgtqmbamrcvoou")
    public suspend fun lagId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lagId = mapped
    }

    internal fun build(): ConnectionAssociationArgs = ConnectionAssociationArgs(
        connectionId = connectionId,
        lagId = lagId,
    )
}
