@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.directconnect.kotlin

import com.pulumi.aws.directconnect.ConnectionConfirmationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a confirmation of the creation of the specified hosted connection on an interconnect.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.directconnect.ConnectionConfirmation;
 * import com.pulumi.aws.directconnect.ConnectionConfirmationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var confirmation = new ConnectionConfirmation("confirmation", ConnectionConfirmationArgs.builder()
 *             .connectionId("dxcon-ffabc123")
 *             .build());
 *     }
 * }
 * ```
 * @property connectionId The ID of the hosted connection.
 */
public data class ConnectionConfirmationArgs(
    public val connectionId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.directconnect.ConnectionConfirmationArgs> {
    override fun toJava(): com.pulumi.aws.directconnect.ConnectionConfirmationArgs =
        com.pulumi.aws.directconnect.ConnectionConfirmationArgs.builder()
            .connectionId(connectionId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConnectionConfirmationArgs].
 */
@PulumiTagMarker
public class ConnectionConfirmationArgsBuilder internal constructor() {
    private var connectionId: Output<String>? = null

    /**
     * @param value The ID of the hosted connection.
     */
    @JvmName("dhnkcwinyjapdmjx")
    public suspend fun connectionId(`value`: Output<String>) {
        this.connectionId = value
    }

    /**
     * @param value The ID of the hosted connection.
     */
    @JvmName("ykajhgaltkgrxmls")
    public suspend fun connectionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionId = mapped
    }

    internal fun build(): ConnectionConfirmationArgs = ConnectionConfirmationArgs(
        connectionId = connectionId,
    )
}
