@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.directconnect.kotlin

import com.pulumi.aws.directconnect.DirectconnectFunctions.getConnectionPlain
import com.pulumi.aws.directconnect.DirectconnectFunctions.getGatewayPlain
import com.pulumi.aws.directconnect.DirectconnectFunctions.getLocationPlain
import com.pulumi.aws.directconnect.DirectconnectFunctions.getLocationsPlain
import com.pulumi.aws.directconnect.DirectconnectFunctions.getRouterConfigurationPlain
import com.pulumi.aws.directconnect.kotlin.inputs.GetConnectionPlainArgs
import com.pulumi.aws.directconnect.kotlin.inputs.GetConnectionPlainArgsBuilder
import com.pulumi.aws.directconnect.kotlin.inputs.GetGatewayPlainArgs
import com.pulumi.aws.directconnect.kotlin.inputs.GetGatewayPlainArgsBuilder
import com.pulumi.aws.directconnect.kotlin.inputs.GetLocationPlainArgs
import com.pulumi.aws.directconnect.kotlin.inputs.GetLocationPlainArgsBuilder
import com.pulumi.aws.directconnect.kotlin.inputs.GetRouterConfigurationPlainArgs
import com.pulumi.aws.directconnect.kotlin.inputs.GetRouterConfigurationPlainArgsBuilder
import com.pulumi.aws.directconnect.kotlin.outputs.GetConnectionResult
import com.pulumi.aws.directconnect.kotlin.outputs.GetGatewayResult
import com.pulumi.aws.directconnect.kotlin.outputs.GetLocationResult
import com.pulumi.aws.directconnect.kotlin.outputs.GetLocationsResult
import com.pulumi.aws.directconnect.kotlin.outputs.GetRouterConfigurationResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.directconnect.kotlin.outputs.GetConnectionResult.Companion.toKotlin as getConnectionResultToKotlin
import com.pulumi.aws.directconnect.kotlin.outputs.GetGatewayResult.Companion.toKotlin as getGatewayResultToKotlin
import com.pulumi.aws.directconnect.kotlin.outputs.GetLocationResult.Companion.toKotlin as getLocationResultToKotlin
import com.pulumi.aws.directconnect.kotlin.outputs.GetLocationsResult.Companion.toKotlin as getLocationsResultToKotlin
import com.pulumi.aws.directconnect.kotlin.outputs.GetRouterConfigurationResult.Companion.toKotlin as getRouterConfigurationResultToKotlin

public object DirectconnectFunctions {
    /**
     * Retrieve information about a Direct Connect Connection.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.directconnect.DirectconnectFunctions;
     * import com.pulumi.aws.directconnect.inputs.GetConnectionArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = DirectconnectFunctions.getConnection(GetConnectionArgs.builder()
     *             .name("tf-dx-connection")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getConnection.
     * @return A collection of values returned by getConnection.
     */
    public suspend fun getConnection(argument: GetConnectionPlainArgs): GetConnectionResult =
        getConnectionResultToKotlin(getConnectionPlain(argument.toJava()).await())

    /**
     * @see [getConnection].
     * @param name Name of the connection to retrieve.
     * @param tags Map of tags for the resource.
     * @return A collection of values returned by getConnection.
     */
    public suspend fun getConnection(name: String, tags: Map<String, String>? = null):
        GetConnectionResult {
        val argument = GetConnectionPlainArgs(
            name = name,
            tags = tags,
        )
        return getConnectionResultToKotlin(getConnectionPlain(argument.toJava()).await())
    }

    /**
     * @see [getConnection].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;directconnect&#46;kotlin&#46;inputs&#46;GetConnectionPlainArgs].
     * @return A collection of values returned by getConnection.
     */
    public suspend fun getConnection(argument: suspend GetConnectionPlainArgsBuilder.() -> Unit):
        GetConnectionResult {
        val builder = GetConnectionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getConnectionResultToKotlin(getConnectionPlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieve information about a Direct Connect Gateway.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.directconnect.DirectconnectFunctions;
     * import com.pulumi.aws.directconnect.inputs.GetGatewayArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = DirectconnectFunctions.getGateway(GetGatewayArgs.builder()
     *             .name("example")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getGateway.
     * @return A collection of values returned by getGateway.
     */
    public suspend fun getGateway(argument: GetGatewayPlainArgs): GetGatewayResult =
        getGatewayResultToKotlin(getGatewayPlain(argument.toJava()).await())

    /**
     * @see [getGateway].
     * @param name Name of the gateway to retrieve.
     * @return A collection of values returned by getGateway.
     */
    public suspend fun getGateway(name: String): GetGatewayResult {
        val argument = GetGatewayPlainArgs(
            name = name,
        )
        return getGatewayResultToKotlin(getGatewayPlain(argument.toJava()).await())
    }

    /**
     * @see [getGateway].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;directconnect&#46;kotlin&#46;inputs&#46;GetGatewayPlainArgs].
     * @return A collection of values returned by getGateway.
     */
    public suspend fun getGateway(argument: suspend GetGatewayPlainArgsBuilder.() -> Unit):
        GetGatewayResult {
        val builder = GetGatewayPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getGatewayResultToKotlin(getGatewayPlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieve information about a specific AWS Direct Connect location in the current AWS Region.
     * These are the locations that can be specified when configuring `aws.directconnect.Connection` or `aws.directconnect.LinkAggregationGroup` resources.
     * > **Note:** This data source is different from the `aws.directconnect.getLocations` data source which retrieves information about all the AWS Direct Connect locations in the current AWS Region.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.directconnect.DirectconnectFunctions;
     * import com.pulumi.aws.directconnect.inputs.GetLocationArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = DirectconnectFunctions.getLocation(GetLocationArgs.builder()
     *             .locationCode("CS32A-24FL")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getLocation.
     * @return A collection of values returned by getLocation.
     */
    public suspend fun getLocation(argument: GetLocationPlainArgs): GetLocationResult =
        getLocationResultToKotlin(getLocationPlain(argument.toJava()).await())

    /**
     * @see [getLocation].
     * @param locationCode Code for the location to retrieve.
     * @return A collection of values returned by getLocation.
     */
    public suspend fun getLocation(locationCode: String): GetLocationResult {
        val argument = GetLocationPlainArgs(
            locationCode = locationCode,
        )
        return getLocationResultToKotlin(getLocationPlain(argument.toJava()).await())
    }

    /**
     * @see [getLocation].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;directconnect&#46;kotlin&#46;inputs&#46;GetLocationPlainArgs].
     * @return A collection of values returned by getLocation.
     */
    public suspend fun getLocation(argument: suspend GetLocationPlainArgsBuilder.() -> Unit):
        GetLocationResult {
        val builder = GetLocationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getLocationResultToKotlin(getLocationPlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieve information about the AWS Direct Connect locations in the current AWS Region.
     * These are the locations that can be specified when configuring `aws.directconnect.Connection` or `aws.directconnect.LinkAggregationGroup` resources.
     * > **Note:** This data source is different from the `aws.directconnect.getLocation` data source which retrieves information about a specific AWS Direct Connect location in the current AWS Region.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.directconnect.DirectconnectFunctions;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var available = DirectconnectFunctions.getLocations();
     *     }
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.directconnect.DirectconnectFunctions;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var available = DirectconnectFunctions.getLocations();
     *     }
     * }
     * ```
     * @param argument Retrieve information about the AWS Direct Connect locations in the current AWS Region.
     * These are the locations that can be specified when configuring `aws.directconnect.Connection` or `aws.directconnect.LinkAggregationGroup` resources.
     * > **Note:** This data source is different from the `aws.directconnect.getLocation` data source which retrieves information about a specific AWS Direct Connect location in the current AWS Region.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.directconnect.DirectconnectFunctions;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var available = DirectconnectFunctions.getLocations();
     *     }
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.directconnect.DirectconnectFunctions;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var available = DirectconnectFunctions.getLocations();
     *     }
     * }
     * ```
     * @return A collection of values returned by getLocations.
     */
    public suspend fun getLocations(): GetLocationsResult =
        getLocationsResultToKotlin(getLocationsPlain().await())

    /**
     * Data source for retrieving Router Configuration instructions for a given AWS Direct Connect Virtual Interface and Router Type.
     * ## Example Usage
     * ### Basic Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.directconnect.DirectconnectFunctions;
     * import com.pulumi.aws.directconnect.inputs.GetRouterConfigurationArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = DirectconnectFunctions.getRouterConfiguration(GetRouterConfigurationArgs.builder()
     *             .routerTypeIdentifier("CiscoSystemsInc-2900SeriesRouters-IOS124")
     *             .virtualInterfaceId("dxvif-abcde123")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getRouterConfiguration.
     * @return A collection of values returned by getRouterConfiguration.
     */
    public suspend fun getRouterConfiguration(argument: GetRouterConfigurationPlainArgs):
        GetRouterConfigurationResult =
        getRouterConfigurationResultToKotlin(getRouterConfigurationPlain(argument.toJava()).await())

    /**
     * @see [getRouterConfiguration].
     * @param routerTypeIdentifier ID of the Router Type. For example: `CiscoSystemsInc-2900SeriesRouters-IOS124`
     * There is currently no AWS API to retrieve the full list of `router_type_identifier` values. Here is a list of known `RouterType` objects that can be used:
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * ```
     * ```python
     * import pulumi
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * return await Deployment.RunAsync(() =>
     * {
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *     }
     * }
     * ```
     * ```yaml
     * {}
     * ```
     * @param virtualInterfaceId ID of the Direct Connect Virtual Interface
     * @return A collection of values returned by getRouterConfiguration.
     */
    public suspend fun getRouterConfiguration(
        routerTypeIdentifier: String,
        virtualInterfaceId: String,
    ): GetRouterConfigurationResult {
        val argument = GetRouterConfigurationPlainArgs(
            routerTypeIdentifier = routerTypeIdentifier,
            virtualInterfaceId = virtualInterfaceId,
        )
        return getRouterConfigurationResultToKotlin(getRouterConfigurationPlain(argument.toJava()).await())
    }

    /**
     * @see [getRouterConfiguration].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;directconnect&#46;kotlin&#46;inputs&#46;GetRouterConfigurationPlainArgs].
     * @return A collection of values returned by getRouterConfiguration.
     */
    public suspend
    fun getRouterConfiguration(argument: suspend GetRouterConfigurationPlainArgsBuilder.() -> Unit):
        GetRouterConfigurationResult {
        val builder = GetRouterConfigurationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRouterConfigurationResultToKotlin(getRouterConfigurationPlain(builtArgument.toJava()).await())
    }
}
