@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.directconnect.kotlin

import com.pulumi.aws.directconnect.GatewayArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Direct Connect Gateway.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.directconnect.Gateway;
 * import com.pulumi.aws.directconnect.GatewayArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Gateway("example", GatewayArgs.builder()
 *             .amazonSideAsn("64512")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Direct Connect Gateways using the gateway `id`. For example:
 * ```sh
 *  $ pulumi import aws:directconnect/gateway:Gateway test abcd1234-dcba-5678-be23-cdef9876ab45
 * ```
 * @property amazonSideAsn The ASN to be configured on the Amazon side of the connection. The ASN must be in the private range of 64,512 to 65,534 or 4,200,000,000 to 4,294,967,294.
 * @property name The name of the connection.
 */
public data class GatewayArgs(
    public val amazonSideAsn: Output<String>? = null,
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.directconnect.GatewayArgs> {
    override fun toJava(): com.pulumi.aws.directconnect.GatewayArgs =
        com.pulumi.aws.directconnect.GatewayArgs.builder()
            .amazonSideAsn(amazonSideAsn?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GatewayArgs].
 */
@PulumiTagMarker
public class GatewayArgsBuilder internal constructor() {
    private var amazonSideAsn: Output<String>? = null

    private var name: Output<String>? = null

    /**
     * @param value The ASN to be configured on the Amazon side of the connection. The ASN must be in the private range of 64,512 to 65,534 or 4,200,000,000 to 4,294,967,294.
     */
    @JvmName("pnrcxiangccofflk")
    public suspend fun amazonSideAsn(`value`: Output<String>) {
        this.amazonSideAsn = value
    }

    /**
     * @param value The name of the connection.
     */
    @JvmName("vgnlsksgycxbefnd")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The ASN to be configured on the Amazon side of the connection. The ASN must be in the private range of 64,512 to 65,534 or 4,200,000,000 to 4,294,967,294.
     */
    @JvmName("krewgsgeruvhhqgr")
    public suspend fun amazonSideAsn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.amazonSideAsn = mapped
    }

    /**
     * @param value The name of the connection.
     */
    @JvmName("mrgudphghqpjfekc")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): GatewayArgs = GatewayArgs(
        amazonSideAsn = amazonSideAsn,
        name = name,
    )
}
