@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.directconnect.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [GatewayAssociation].
 */
@PulumiTagMarker
public class GatewayAssociationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: GatewayAssociationArgs = GatewayAssociationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend GatewayAssociationArgsBuilder.() -> Unit) {
        val builder = GatewayAssociationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): GatewayAssociation {
        val builtJavaResource = com.pulumi.aws.directconnect.GatewayAssociation(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return GatewayAssociation(builtJavaResource)
    }
}

/**
 * Associates a Direct Connect Gateway with a VGW or transit gateway.
 * To create a cross-account association, create an `aws.directconnect.GatewayAssociationProposal` resource
 * in the AWS account that owns the VGW or transit gateway and then accept the proposal in the AWS account that owns the Direct Connect Gateway
 * by creating an `aws.directconnect.GatewayAssociation` resource with the `proposal_id` and `associated_gateway_owner_account_id` attributes set.
 * ## Example Usage
 * ### VPN Gateway Association
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.directconnect.Gateway;
 * import com.pulumi.aws.directconnect.GatewayArgs;
 * import com.pulumi.aws.ec2.Vpc;
 * import com.pulumi.aws.ec2.VpcArgs;
 * import com.pulumi.aws.ec2.VpnGateway;
 * import com.pulumi.aws.ec2.VpnGatewayArgs;
 * import com.pulumi.aws.directconnect.GatewayAssociation;
 * import com.pulumi.aws.directconnect.GatewayAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleGateway = new Gateway("exampleGateway", GatewayArgs.builder()
 *             .amazonSideAsn("64512")
 *             .build());
 *         var exampleVpc = new Vpc("exampleVpc", VpcArgs.builder()
 *             .cidrBlock("10.255.255.0/28")
 *             .build());
 *         var exampleVpnGateway = new VpnGateway("exampleVpnGateway", VpnGatewayArgs.builder()
 *             .vpcId(exampleVpc.id())
 *             .build());
 *         var exampleGatewayAssociation = new GatewayAssociation("exampleGatewayAssociation", GatewayAssociationArgs.builder()
 *             .dxGatewayId(exampleGateway.id())
 *             .associatedGatewayId(exampleVpnGateway.id())
 *             .build());
 *     }
 * }
 * ```
 * ### Transit Gateway Association
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.directconnect.Gateway;
 * import com.pulumi.aws.directconnect.GatewayArgs;
 * import com.pulumi.aws.ec2transitgateway.TransitGateway;
 * import com.pulumi.aws.directconnect.GatewayAssociation;
 * import com.pulumi.aws.directconnect.GatewayAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleGateway = new Gateway("exampleGateway", GatewayArgs.builder()
 *             .amazonSideAsn("64512")
 *             .build());
 *         var exampleTransitGateway = new TransitGateway("exampleTransitGateway");
 *         var exampleGatewayAssociation = new GatewayAssociation("exampleGatewayAssociation", GatewayAssociationArgs.builder()
 *             .dxGatewayId(exampleGateway.id())
 *             .associatedGatewayId(exampleTransitGateway.id())
 *             .allowedPrefixes(
 *                 "10.255.255.0/30",
 *                 "10.255.255.8/30")
 *             .build());
 *     }
 * }
 * ```
 * ### Allowed Prefixes
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.directconnect.Gateway;
 * import com.pulumi.aws.directconnect.GatewayArgs;
 * import com.pulumi.aws.ec2.Vpc;
 * import com.pulumi.aws.ec2.VpcArgs;
 * import com.pulumi.aws.ec2.VpnGateway;
 * import com.pulumi.aws.ec2.VpnGatewayArgs;
 * import com.pulumi.aws.directconnect.GatewayAssociation;
 * import com.pulumi.aws.directconnect.GatewayAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleGateway = new Gateway("exampleGateway", GatewayArgs.builder()
 *             .amazonSideAsn("64512")
 *             .build());
 *         var exampleVpc = new Vpc("exampleVpc", VpcArgs.builder()
 *             .cidrBlock("10.255.255.0/28")
 *             .build());
 *         var exampleVpnGateway = new VpnGateway("exampleVpnGateway", VpnGatewayArgs.builder()
 *             .vpcId(exampleVpc.id())
 *             .build());
 *         var exampleGatewayAssociation = new GatewayAssociation("exampleGatewayAssociation", GatewayAssociationArgs.builder()
 *             .dxGatewayId(exampleGateway.id())
 *             .associatedGatewayId(exampleVpnGateway.id())
 *             .allowedPrefixes(
 *                 "210.52.109.0/24",
 *                 "175.45.176.0/22")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Direct Connect gateway associations using `dx_gateway_id` together with `associated_gateway_id`. For example:
 * ```sh
 *  $ pulumi import aws:directconnect/gatewayAssociation:GatewayAssociation example 345508c3-7215-4aef-9832-07c125d5bd0f/vgw-98765432
 * ```
 *
 */
public class GatewayAssociation internal constructor(
    override val javaResource: com.pulumi.aws.directconnect.GatewayAssociation,
) : KotlinCustomResource(javaResource, GatewayAssociationMapper) {
    /**
     * VPC prefixes (CIDRs) to advertise to the Direct Connect gateway. Defaults to the CIDR block of the VPC associated with the Virtual Gateway. To enable drift detection, must be configured.
     */
    public val allowedPrefixes: Output<List<String>>
        get() = javaResource.allowedPrefixes().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The ID of the VGW or transit gateway with which to associate the Direct Connect gateway.
     * Used for single account Direct Connect gateway associations.
     */
    public val associatedGatewayId: Output<String>
        get() = javaResource.associatedGatewayId().applyValue({ args0 -> args0 })

    /**
     * The ID of the AWS account that owns the VGW or transit gateway with which to associate the Direct Connect gateway.
     * Used for cross-account Direct Connect gateway associations.
     */
    public val associatedGatewayOwnerAccountId: Output<String>
        get() = javaResource.associatedGatewayOwnerAccountId().applyValue({ args0 -> args0 })

    /**
     * The type of the associated gateway, `transitGateway` or `virtualPrivateGateway`.
     */
    public val associatedGatewayType: Output<String>
        get() = javaResource.associatedGatewayType().applyValue({ args0 -> args0 })

    /**
     * The ID of the Direct Connect gateway association.
     */
    public val dxGatewayAssociationId: Output<String>
        get() = javaResource.dxGatewayAssociationId().applyValue({ args0 -> args0 })

    /**
     * The ID of the Direct Connect gateway.
     */
    public val dxGatewayId: Output<String>
        get() = javaResource.dxGatewayId().applyValue({ args0 -> args0 })

    /**
     * The ID of the AWS account that owns the Direct Connect gateway.
     */
    public val dxGatewayOwnerAccountId: Output<String>
        get() = javaResource.dxGatewayOwnerAccountId().applyValue({ args0 -> args0 })

    /**
     * The ID of the Direct Connect gateway association proposal.
     * Used for cross-account Direct Connect gateway associations.
     */
    public val proposalId: Output<String>?
        get() = javaResource.proposalId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    @Deprecated(
        message = """
  use 'associated_gateway_id' argument instead
  """,
    )
    public val vpnGatewayId: Output<String>?
        get() = javaResource.vpnGatewayId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object GatewayAssociationMapper : ResourceMapper<GatewayAssociation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.directconnect.GatewayAssociation::class == javaResource::class

    override fun map(javaResource: Resource): GatewayAssociation = GatewayAssociation(
        javaResource as
            com.pulumi.aws.directconnect.GatewayAssociation,
    )
}

/**
 * @see [GatewayAssociation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [GatewayAssociation].
 */
public suspend fun gatewayAssociation(
    name: String,
    block: suspend GatewayAssociationResourceBuilder.() -> Unit,
): GatewayAssociation {
    val builder = GatewayAssociationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [GatewayAssociation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun gatewayAssociation(name: String): GatewayAssociation {
    val builder = GatewayAssociationResourceBuilder()
    builder.name(name)
    return builder.build()
}
