@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.directconnect.kotlin

import com.pulumi.aws.directconnect.GatewayAssociationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Associates a Direct Connect Gateway with a VGW or transit gateway.
 * To create a cross-account association, create an `aws.directconnect.GatewayAssociationProposal` resource
 * in the AWS account that owns the VGW or transit gateway and then accept the proposal in the AWS account that owns the Direct Connect Gateway
 * by creating an `aws.directconnect.GatewayAssociation` resource with the `proposal_id` and `associated_gateway_owner_account_id` attributes set.
 * ## Example Usage
 * ### VPN Gateway Association
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.directconnect.Gateway;
 * import com.pulumi.aws.directconnect.GatewayArgs;
 * import com.pulumi.aws.ec2.Vpc;
 * import com.pulumi.aws.ec2.VpcArgs;
 * import com.pulumi.aws.ec2.VpnGateway;
 * import com.pulumi.aws.ec2.VpnGatewayArgs;
 * import com.pulumi.aws.directconnect.GatewayAssociation;
 * import com.pulumi.aws.directconnect.GatewayAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleGateway = new Gateway("exampleGateway", GatewayArgs.builder()
 *             .amazonSideAsn("64512")
 *             .build());
 *         var exampleVpc = new Vpc("exampleVpc", VpcArgs.builder()
 *             .cidrBlock("10.255.255.0/28")
 *             .build());
 *         var exampleVpnGateway = new VpnGateway("exampleVpnGateway", VpnGatewayArgs.builder()
 *             .vpcId(exampleVpc.id())
 *             .build());
 *         var exampleGatewayAssociation = new GatewayAssociation("exampleGatewayAssociation", GatewayAssociationArgs.builder()
 *             .dxGatewayId(exampleGateway.id())
 *             .associatedGatewayId(exampleVpnGateway.id())
 *             .build());
 *     }
 * }
 * ```
 * ### Transit Gateway Association
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.directconnect.Gateway;
 * import com.pulumi.aws.directconnect.GatewayArgs;
 * import com.pulumi.aws.ec2transitgateway.TransitGateway;
 * import com.pulumi.aws.directconnect.GatewayAssociation;
 * import com.pulumi.aws.directconnect.GatewayAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleGateway = new Gateway("exampleGateway", GatewayArgs.builder()
 *             .amazonSideAsn("64512")
 *             .build());
 *         var exampleTransitGateway = new TransitGateway("exampleTransitGateway");
 *         var exampleGatewayAssociation = new GatewayAssociation("exampleGatewayAssociation", GatewayAssociationArgs.builder()
 *             .dxGatewayId(exampleGateway.id())
 *             .associatedGatewayId(exampleTransitGateway.id())
 *             .allowedPrefixes(
 *                 "10.255.255.0/30",
 *                 "10.255.255.8/30")
 *             .build());
 *     }
 * }
 * ```
 * ### Allowed Prefixes
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.directconnect.Gateway;
 * import com.pulumi.aws.directconnect.GatewayArgs;
 * import com.pulumi.aws.ec2.Vpc;
 * import com.pulumi.aws.ec2.VpcArgs;
 * import com.pulumi.aws.ec2.VpnGateway;
 * import com.pulumi.aws.ec2.VpnGatewayArgs;
 * import com.pulumi.aws.directconnect.GatewayAssociation;
 * import com.pulumi.aws.directconnect.GatewayAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleGateway = new Gateway("exampleGateway", GatewayArgs.builder()
 *             .amazonSideAsn("64512")
 *             .build());
 *         var exampleVpc = new Vpc("exampleVpc", VpcArgs.builder()
 *             .cidrBlock("10.255.255.0/28")
 *             .build());
 *         var exampleVpnGateway = new VpnGateway("exampleVpnGateway", VpnGatewayArgs.builder()
 *             .vpcId(exampleVpc.id())
 *             .build());
 *         var exampleGatewayAssociation = new GatewayAssociation("exampleGatewayAssociation", GatewayAssociationArgs.builder()
 *             .dxGatewayId(exampleGateway.id())
 *             .associatedGatewayId(exampleVpnGateway.id())
 *             .allowedPrefixes(
 *                 "210.52.109.0/24",
 *                 "175.45.176.0/22")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Direct Connect gateway associations using `dx_gateway_id` together with `associated_gateway_id`. For example:
 * ```sh
 *  $ pulumi import aws:directconnect/gatewayAssociation:GatewayAssociation example 345508c3-7215-4aef-9832-07c125d5bd0f/vgw-98765432
 * ```
 * @property allowedPrefixes VPC prefixes (CIDRs) to advertise to the Direct Connect gateway. Defaults to the CIDR block of the VPC associated with the Virtual Gateway. To enable drift detection, must be configured.
 * @property associatedGatewayId The ID of the VGW or transit gateway with which to associate the Direct Connect gateway.
 * Used for single account Direct Connect gateway associations.
 * @property associatedGatewayOwnerAccountId The ID of the AWS account that owns the VGW or transit gateway with which to associate the Direct Connect gateway.
 * Used for cross-account Direct Connect gateway associations.
 * @property dxGatewayId The ID of the Direct Connect gateway.
 * @property proposalId The ID of the Direct Connect gateway association proposal.
 * Used for cross-account Direct Connect gateway associations.
 * @property vpnGatewayId
 */
public data class GatewayAssociationArgs(
    public val allowedPrefixes: Output<List<String>>? = null,
    public val associatedGatewayId: Output<String>? = null,
    public val associatedGatewayOwnerAccountId: Output<String>? = null,
    public val dxGatewayId: Output<String>? = null,
    public val proposalId: Output<String>? = null,
    @Deprecated(
        message = """
  use 'associated_gateway_id' argument instead
  """,
    )
    public val vpnGatewayId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.directconnect.GatewayAssociationArgs> {
    override fun toJava(): com.pulumi.aws.directconnect.GatewayAssociationArgs =
        com.pulumi.aws.directconnect.GatewayAssociationArgs.builder()
            .allowedPrefixes(allowedPrefixes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .associatedGatewayId(associatedGatewayId?.applyValue({ args0 -> args0 }))
            .associatedGatewayOwnerAccountId(associatedGatewayOwnerAccountId?.applyValue({ args0 -> args0 }))
            .dxGatewayId(dxGatewayId?.applyValue({ args0 -> args0 }))
            .proposalId(proposalId?.applyValue({ args0 -> args0 }))
            .vpnGatewayId(vpnGatewayId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GatewayAssociationArgs].
 */
@PulumiTagMarker
public class GatewayAssociationArgsBuilder internal constructor() {
    private var allowedPrefixes: Output<List<String>>? = null

    private var associatedGatewayId: Output<String>? = null

    private var associatedGatewayOwnerAccountId: Output<String>? = null

    private var dxGatewayId: Output<String>? = null

    private var proposalId: Output<String>? = null

    private var vpnGatewayId: Output<String>? = null

    /**
     * @param value VPC prefixes (CIDRs) to advertise to the Direct Connect gateway. Defaults to the CIDR block of the VPC associated with the Virtual Gateway. To enable drift detection, must be configured.
     */
    @JvmName("kavvcuqnbyrjeexp")
    public suspend fun allowedPrefixes(`value`: Output<List<String>>) {
        this.allowedPrefixes = value
    }

    @JvmName("odssucjdfbfjdegf")
    public suspend fun allowedPrefixes(vararg values: Output<String>) {
        this.allowedPrefixes = Output.all(values.asList())
    }

    /**
     * @param values VPC prefixes (CIDRs) to advertise to the Direct Connect gateway. Defaults to the CIDR block of the VPC associated with the Virtual Gateway. To enable drift detection, must be configured.
     */
    @JvmName("qpqteoorncaigppt")
    public suspend fun allowedPrefixes(values: List<Output<String>>) {
        this.allowedPrefixes = Output.all(values)
    }

    /**
     * @param value The ID of the VGW or transit gateway with which to associate the Direct Connect gateway.
     * Used for single account Direct Connect gateway associations.
     */
    @JvmName("yevsfsqqtvntqxmt")
    public suspend fun associatedGatewayId(`value`: Output<String>) {
        this.associatedGatewayId = value
    }

    /**
     * @param value The ID of the AWS account that owns the VGW or transit gateway with which to associate the Direct Connect gateway.
     * Used for cross-account Direct Connect gateway associations.
     */
    @JvmName("beqcwkbhwsteryxh")
    public suspend fun associatedGatewayOwnerAccountId(`value`: Output<String>) {
        this.associatedGatewayOwnerAccountId = value
    }

    /**
     * @param value The ID of the Direct Connect gateway.
     */
    @JvmName("bmafpivjxrntgcom")
    public suspend fun dxGatewayId(`value`: Output<String>) {
        this.dxGatewayId = value
    }

    /**
     * @param value The ID of the Direct Connect gateway association proposal.
     * Used for cross-account Direct Connect gateway associations.
     */
    @JvmName("wjeqicfdklpmngjo")
    public suspend fun proposalId(`value`: Output<String>) {
        this.proposalId = value
    }

    /**
     * @param value
     */
    @Deprecated(
        message = """
  use 'associated_gateway_id' argument instead
  """,
    )
    @JvmName("hvrwsgliynunnrav")
    public suspend fun vpnGatewayId(`value`: Output<String>) {
        this.vpnGatewayId = value
    }

    /**
     * @param value VPC prefixes (CIDRs) to advertise to the Direct Connect gateway. Defaults to the CIDR block of the VPC associated with the Virtual Gateway. To enable drift detection, must be configured.
     */
    @JvmName("itjvrdtsupglavnn")
    public suspend fun allowedPrefixes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowedPrefixes = mapped
    }

    /**
     * @param values VPC prefixes (CIDRs) to advertise to the Direct Connect gateway. Defaults to the CIDR block of the VPC associated with the Virtual Gateway. To enable drift detection, must be configured.
     */
    @JvmName("dptdvbsefhjwotnt")
    public suspend fun allowedPrefixes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedPrefixes = mapped
    }

    /**
     * @param value The ID of the VGW or transit gateway with which to associate the Direct Connect gateway.
     * Used for single account Direct Connect gateway associations.
     */
    @JvmName("titxkyimlctagrrf")
    public suspend fun associatedGatewayId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.associatedGatewayId = mapped
    }

    /**
     * @param value The ID of the AWS account that owns the VGW or transit gateway with which to associate the Direct Connect gateway.
     * Used for cross-account Direct Connect gateway associations.
     */
    @JvmName("jijcycmstvcchktq")
    public suspend fun associatedGatewayOwnerAccountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.associatedGatewayOwnerAccountId = mapped
    }

    /**
     * @param value The ID of the Direct Connect gateway.
     */
    @JvmName("ovcmnfckxiligget")
    public suspend fun dxGatewayId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dxGatewayId = mapped
    }

    /**
     * @param value The ID of the Direct Connect gateway association proposal.
     * Used for cross-account Direct Connect gateway associations.
     */
    @JvmName("bojhmyvvirwmrjqe")
    public suspend fun proposalId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.proposalId = mapped
    }

    /**
     * @param value
     */
    @Deprecated(
        message = """
  use 'associated_gateway_id' argument instead
  """,
    )
    @JvmName("lhrqghymiwhhuxvl")
    public suspend fun vpnGatewayId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpnGatewayId = mapped
    }

    internal fun build(): GatewayAssociationArgs = GatewayAssociationArgs(
        allowedPrefixes = allowedPrefixes,
        associatedGatewayId = associatedGatewayId,
        associatedGatewayOwnerAccountId = associatedGatewayOwnerAccountId,
        dxGatewayId = dxGatewayId,
        proposalId = proposalId,
        vpnGatewayId = vpnGatewayId,
    )
}
