@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.directconnect.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [GatewayAssociationProposal].
 */
@PulumiTagMarker
public class GatewayAssociationProposalResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: GatewayAssociationProposalArgs = GatewayAssociationProposalArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend GatewayAssociationProposalArgsBuilder.() -> Unit) {
        val builder = GatewayAssociationProposalArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): GatewayAssociationProposal {
        val builtJavaResource =
            com.pulumi.aws.directconnect.GatewayAssociationProposal(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return GatewayAssociationProposal(builtJavaResource)
    }
}

/**
 * Manages a Direct Connect Gateway Association Proposal, typically for enabling cross-account associations. For single account associations, see the `aws.directconnect.GatewayAssociation` resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.directconnect.GatewayAssociationProposal;
 * import com.pulumi.aws.directconnect.GatewayAssociationProposalArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new GatewayAssociationProposal("example", GatewayAssociationProposalArgs.builder()
 *             .dxGatewayId(aws_dx_gateway.example().id())
 *             .dxGatewayOwnerAccountId(aws_dx_gateway.example().owner_account_id())
 *             .associatedGatewayId(aws_vpn_gateway.example().id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using a proposal ID, Direct Connect Gateway ID and associated gateway ID separated by `/`:
 * __With `pulumi import`__, import Direct Connect Gateway Association Proposals using either a proposal ID or proposal ID, Direct Connect Gateway ID and associated gateway ID separated by `/`. For example:
 * Using a proposal ID:
 * ```sh
 *  $ pulumi import aws:directconnect/gatewayAssociationProposal:GatewayAssociationProposal example ac90e981-b718-4364-872d-65478c84fafe
 * ```
 *  Using a proposal ID, Direct Connect Gateway ID and associated gateway ID separated by `/`:
 * ```sh
 *  $ pulumi import aws:directconnect/gatewayAssociationProposal:GatewayAssociationProposal example ac90e981-b718-4364-872d-65478c84fafe/abcd1234-dcba-5678-be23-cdef9876ab45/vgw-12345678
 * ```
 *  The latter case is useful when a previous proposal has been accepted and deleted by AWS. The `aws_dx_gateway_association_proposal` resource will then represent a pseudo-proposal for the same Direct Connect Gateway and associated gateway. If no previous proposal is available, use a tool like [`uuidgen`](http://manpages.ubuntu.com/manpages/bionic/man1/uuidgen.1.html) to generate a new random pseudo-proposal ID.
 */
public class GatewayAssociationProposal internal constructor(
    override val javaResource: com.pulumi.aws.directconnect.GatewayAssociationProposal,
) : KotlinCustomResource(javaResource, GatewayAssociationProposalMapper) {
    /**
     * VPC prefixes (CIDRs) to advertise to the Direct Connect gateway. Defaults to the CIDR block of the VPC associated with the Virtual Gateway. To enable drift detection, must be configured.
     */
    public val allowedPrefixes: Output<List<String>>
        get() = javaResource.allowedPrefixes().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The ID of the VGW or transit gateway with which to associate the Direct Connect gateway.
     */
    public val associatedGatewayId: Output<String>
        get() = javaResource.associatedGatewayId().applyValue({ args0 -> args0 })

    /**
     * The ID of the AWS account that owns the VGW or transit gateway with which to associate the Direct Connect gateway.
     */
    public val associatedGatewayOwnerAccountId: Output<String>
        get() = javaResource.associatedGatewayOwnerAccountId().applyValue({ args0 -> args0 })

    /**
     * The type of the associated gateway, `transitGateway` or `virtualPrivateGateway`.
     */
    public val associatedGatewayType: Output<String>
        get() = javaResource.associatedGatewayType().applyValue({ args0 -> args0 })

    /**
     * Direct Connect Gateway identifier.
     */
    public val dxGatewayId: Output<String>
        get() = javaResource.dxGatewayId().applyValue({ args0 -> args0 })

    /**
     * AWS Account identifier of the Direct Connect Gateway's owner.
     */
    public val dxGatewayOwnerAccountId: Output<String>
        get() = javaResource.dxGatewayOwnerAccountId().applyValue({ args0 -> args0 })
}

public object GatewayAssociationProposalMapper : ResourceMapper<GatewayAssociationProposal> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.directconnect.GatewayAssociationProposal::class == javaResource::class

    override fun map(javaResource: Resource): GatewayAssociationProposal =
        GatewayAssociationProposal(
            javaResource as
                com.pulumi.aws.directconnect.GatewayAssociationProposal,
        )
}

/**
 * @see [GatewayAssociationProposal].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [GatewayAssociationProposal].
 */
public suspend fun gatewayAssociationProposal(
    name: String,
    block: suspend GatewayAssociationProposalResourceBuilder.() -> Unit,
):
    GatewayAssociationProposal {
    val builder = GatewayAssociationProposalResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [GatewayAssociationProposal].
 * @param name The _unique_ name of the resulting resource.
 */
public fun gatewayAssociationProposal(name: String): GatewayAssociationProposal {
    val builder = GatewayAssociationProposalResourceBuilder()
    builder.name(name)
    return builder.build()
}
