@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.directconnect.kotlin

import com.pulumi.aws.directconnect.GatewayAssociationProposalArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Manages a Direct Connect Gateway Association Proposal, typically for enabling cross-account associations. For single account associations, see the `aws.directconnect.GatewayAssociation` resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.directconnect.GatewayAssociationProposal;
 * import com.pulumi.aws.directconnect.GatewayAssociationProposalArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new GatewayAssociationProposal("example", GatewayAssociationProposalArgs.builder()
 *             .dxGatewayId(aws_dx_gateway.example().id())
 *             .dxGatewayOwnerAccountId(aws_dx_gateway.example().owner_account_id())
 *             .associatedGatewayId(aws_vpn_gateway.example().id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using a proposal ID, Direct Connect Gateway ID and associated gateway ID separated by `/`:
 * __With `pulumi import`__, import Direct Connect Gateway Association Proposals using either a proposal ID or proposal ID, Direct Connect Gateway ID and associated gateway ID separated by `/`. For example:
 * Using a proposal ID:
 * ```sh
 *  $ pulumi import aws:directconnect/gatewayAssociationProposal:GatewayAssociationProposal example ac90e981-b718-4364-872d-65478c84fafe
 * ```
 *  Using a proposal ID, Direct Connect Gateway ID and associated gateway ID separated by `/`:
 * ```sh
 *  $ pulumi import aws:directconnect/gatewayAssociationProposal:GatewayAssociationProposal example ac90e981-b718-4364-872d-65478c84fafe/abcd1234-dcba-5678-be23-cdef9876ab45/vgw-12345678
 * ```
 *  The latter case is useful when a previous proposal has been accepted and deleted by AWS. The `aws_dx_gateway_association_proposal` resource will then represent a pseudo-proposal for the same Direct Connect Gateway and associated gateway. If no previous proposal is available, use a tool like [`uuidgen`](http://manpages.ubuntu.com/manpages/bionic/man1/uuidgen.1.html) to generate a new random pseudo-proposal ID.
 * @property allowedPrefixes VPC prefixes (CIDRs) to advertise to the Direct Connect gateway. Defaults to the CIDR block of the VPC associated with the Virtual Gateway. To enable drift detection, must be configured.
 * @property associatedGatewayId The ID of the VGW or transit gateway with which to associate the Direct Connect gateway.
 * @property dxGatewayId Direct Connect Gateway identifier.
 * @property dxGatewayOwnerAccountId AWS Account identifier of the Direct Connect Gateway's owner.
 */
public data class GatewayAssociationProposalArgs(
    public val allowedPrefixes: Output<List<String>>? = null,
    public val associatedGatewayId: Output<String>? = null,
    public val dxGatewayId: Output<String>? = null,
    public val dxGatewayOwnerAccountId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.directconnect.GatewayAssociationProposalArgs> {
    override fun toJava(): com.pulumi.aws.directconnect.GatewayAssociationProposalArgs =
        com.pulumi.aws.directconnect.GatewayAssociationProposalArgs.builder()
            .allowedPrefixes(allowedPrefixes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .associatedGatewayId(associatedGatewayId?.applyValue({ args0 -> args0 }))
            .dxGatewayId(dxGatewayId?.applyValue({ args0 -> args0 }))
            .dxGatewayOwnerAccountId(dxGatewayOwnerAccountId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GatewayAssociationProposalArgs].
 */
@PulumiTagMarker
public class GatewayAssociationProposalArgsBuilder internal constructor() {
    private var allowedPrefixes: Output<List<String>>? = null

    private var associatedGatewayId: Output<String>? = null

    private var dxGatewayId: Output<String>? = null

    private var dxGatewayOwnerAccountId: Output<String>? = null

    /**
     * @param value VPC prefixes (CIDRs) to advertise to the Direct Connect gateway. Defaults to the CIDR block of the VPC associated with the Virtual Gateway. To enable drift detection, must be configured.
     */
    @JvmName("krfmgwrcwypagqfe")
    public suspend fun allowedPrefixes(`value`: Output<List<String>>) {
        this.allowedPrefixes = value
    }

    @JvmName("txhqsbcrxktvrbcd")
    public suspend fun allowedPrefixes(vararg values: Output<String>) {
        this.allowedPrefixes = Output.all(values.asList())
    }

    /**
     * @param values VPC prefixes (CIDRs) to advertise to the Direct Connect gateway. Defaults to the CIDR block of the VPC associated with the Virtual Gateway. To enable drift detection, must be configured.
     */
    @JvmName("yheybjmnquytvdfd")
    public suspend fun allowedPrefixes(values: List<Output<String>>) {
        this.allowedPrefixes = Output.all(values)
    }

    /**
     * @param value The ID of the VGW or transit gateway with which to associate the Direct Connect gateway.
     */
    @JvmName("ajritujfxdrpkavi")
    public suspend fun associatedGatewayId(`value`: Output<String>) {
        this.associatedGatewayId = value
    }

    /**
     * @param value Direct Connect Gateway identifier.
     */
    @JvmName("aqvtuarrlbboebkc")
    public suspend fun dxGatewayId(`value`: Output<String>) {
        this.dxGatewayId = value
    }

    /**
     * @param value AWS Account identifier of the Direct Connect Gateway's owner.
     */
    @JvmName("kdjhghnsqnthtqfq")
    public suspend fun dxGatewayOwnerAccountId(`value`: Output<String>) {
        this.dxGatewayOwnerAccountId = value
    }

    /**
     * @param value VPC prefixes (CIDRs) to advertise to the Direct Connect gateway. Defaults to the CIDR block of the VPC associated with the Virtual Gateway. To enable drift detection, must be configured.
     */
    @JvmName("whmjtnaeqcueytad")
    public suspend fun allowedPrefixes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowedPrefixes = mapped
    }

    /**
     * @param values VPC prefixes (CIDRs) to advertise to the Direct Connect gateway. Defaults to the CIDR block of the VPC associated with the Virtual Gateway. To enable drift detection, must be configured.
     */
    @JvmName("awljmuslxndvbswv")
    public suspend fun allowedPrefixes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedPrefixes = mapped
    }

    /**
     * @param value The ID of the VGW or transit gateway with which to associate the Direct Connect gateway.
     */
    @JvmName("nwihnnilptctqhtu")
    public suspend fun associatedGatewayId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.associatedGatewayId = mapped
    }

    /**
     * @param value Direct Connect Gateway identifier.
     */
    @JvmName("febhxteahavybydj")
    public suspend fun dxGatewayId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dxGatewayId = mapped
    }

    /**
     * @param value AWS Account identifier of the Direct Connect Gateway's owner.
     */
    @JvmName("xuqjuvxbcxnhwrih")
    public suspend fun dxGatewayOwnerAccountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dxGatewayOwnerAccountId = mapped
    }

    internal fun build(): GatewayAssociationProposalArgs = GatewayAssociationProposalArgs(
        allowedPrefixes = allowedPrefixes,
        associatedGatewayId = associatedGatewayId,
        dxGatewayId = dxGatewayId,
        dxGatewayOwnerAccountId = dxGatewayOwnerAccountId,
    )
}
