@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.directconnect.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [HostedPrivateVirtualInterfaceAccepter].
 */
@PulumiTagMarker
public class HostedPrivateVirtualInterfaceAccepterResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: HostedPrivateVirtualInterfaceAccepterArgs =
        HostedPrivateVirtualInterfaceAccepterArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend
    fun args(block: suspend HostedPrivateVirtualInterfaceAccepterArgsBuilder.() -> Unit) {
        val builder = HostedPrivateVirtualInterfaceAccepterArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): HostedPrivateVirtualInterfaceAccepter {
        val builtJavaResource =
            com.pulumi.aws.directconnect.HostedPrivateVirtualInterfaceAccepter(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return HostedPrivateVirtualInterfaceAccepter(builtJavaResource)
    }
}

/**
 * Provides a resource to manage the accepter's side of a Direct Connect hosted private virtual interface.
 * This resource accepts ownership of a private virtual interface created by another AWS account.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.Provider;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
 * import com.pulumi.aws.ec2.VpnGateway;
 * import com.pulumi.aws.ec2.VpnGatewayArgs;
 * import com.pulumi.aws.directconnect.HostedPrivateVirtualInterface;
 * import com.pulumi.aws.directconnect.HostedPrivateVirtualInterfaceArgs;
 * import com.pulumi.aws.directconnect.HostedPrivateVirtualInterfaceAccepter;
 * import com.pulumi.aws.directconnect.HostedPrivateVirtualInterfaceAccepterArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var accepter = new Provider("accepter");
 *         final var accepterCallerIdentity = AwsFunctions.getCallerIdentity();
 *         var vpnGw = new VpnGateway("vpnGw", VpnGatewayArgs.Empty, CustomResourceOptions.builder()
 *             .provider(aws.accepter())
 *             .build());
 *         var creator = new HostedPrivateVirtualInterface("creator", HostedPrivateVirtualInterfaceArgs.builder()
 *             .connectionId("dxcon-zzzzzzzz")
 *             .ownerAccountId(accepterCallerIdentity.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId()))
 *             .vlan(4094)
 *             .addressFamily("ipv4")
 *             .bgpAsn(65352)
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(vpnGw)
 *                 .build());
 *         var accepterHostedPrivateVirtualInterfaceAccepter = new HostedPrivateVirtualInterfaceAccepter("accepterHostedPrivateVirtualInterfaceAccepter", HostedPrivateVirtualInterfaceAccepterArgs.builder()
 *             .virtualInterfaceId(creator.id())
 *             .vpnGatewayId(vpnGw.id())
 *             .tags(Map.of("Side", "Accepter"))
 *             .build(), CustomResourceOptions.builder()
 *                 .provider(aws.accepter())
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Direct Connect hosted private virtual interfaces using the VIF `id`. For example:
 * ```sh
 *  $ pulumi import aws:directconnect/hostedPrivateVirtualInterfaceAccepter:HostedPrivateVirtualInterfaceAccepter test dxvif-33cc44dd
 * ```
 *
 */
public class HostedPrivateVirtualInterfaceAccepter internal constructor(
    override val javaResource: com.pulumi.aws.directconnect.HostedPrivateVirtualInterfaceAccepter,
) : KotlinCustomResource(javaResource, HostedPrivateVirtualInterfaceAccepterMapper) {
    /**
     * The ARN of the virtual interface.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The ID of the Direct Connect gateway to which to connect the virtual interface.
     */
    public val dxGatewayId: Output<String>?
        get() = javaResource.dxGatewayId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The ID of the Direct Connect virtual interface to accept.
     */
    public val virtualInterfaceId: Output<String>
        get() = javaResource.virtualInterfaceId().applyValue({ args0 -> args0 })

    /**
     * The ID of the virtual private gateway to which to connect the virtual interface.
     */
    public val vpnGatewayId: Output<String>?
        get() = javaResource.vpnGatewayId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object HostedPrivateVirtualInterfaceAccepterMapper :
    ResourceMapper<HostedPrivateVirtualInterfaceAccepter> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.directconnect.HostedPrivateVirtualInterfaceAccepter::class == javaResource::class

    override fun map(javaResource: Resource): HostedPrivateVirtualInterfaceAccepter =
        HostedPrivateVirtualInterfaceAccepter(
            javaResource as
                com.pulumi.aws.directconnect.HostedPrivateVirtualInterfaceAccepter,
        )
}

/**
 * @see [HostedPrivateVirtualInterfaceAccepter].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [HostedPrivateVirtualInterfaceAccepter].
 */
public suspend fun hostedPrivateVirtualInterfaceAccepter(
    name: String,
    block: suspend HostedPrivateVirtualInterfaceAccepterResourceBuilder.() -> Unit,
):
    HostedPrivateVirtualInterfaceAccepter {
    val builder = HostedPrivateVirtualInterfaceAccepterResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [HostedPrivateVirtualInterfaceAccepter].
 * @param name The _unique_ name of the resulting resource.
 */
public fun hostedPrivateVirtualInterfaceAccepter(name: String):
    HostedPrivateVirtualInterfaceAccepter {
    val builder = HostedPrivateVirtualInterfaceAccepterResourceBuilder()
    builder.name(name)
    return builder.build()
}
