@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.directconnect.kotlin

import com.pulumi.aws.directconnect.HostedPrivateVirtualInterfaceAccepterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a resource to manage the accepter's side of a Direct Connect hosted private virtual interface.
 * This resource accepts ownership of a private virtual interface created by another AWS account.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.Provider;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
 * import com.pulumi.aws.ec2.VpnGateway;
 * import com.pulumi.aws.ec2.VpnGatewayArgs;
 * import com.pulumi.aws.directconnect.HostedPrivateVirtualInterface;
 * import com.pulumi.aws.directconnect.HostedPrivateVirtualInterfaceArgs;
 * import com.pulumi.aws.directconnect.HostedPrivateVirtualInterfaceAccepter;
 * import com.pulumi.aws.directconnect.HostedPrivateVirtualInterfaceAccepterArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var accepter = new Provider("accepter");
 *         final var accepterCallerIdentity = AwsFunctions.getCallerIdentity();
 *         var vpnGw = new VpnGateway("vpnGw", VpnGatewayArgs.Empty, CustomResourceOptions.builder()
 *             .provider(aws.accepter())
 *             .build());
 *         var creator = new HostedPrivateVirtualInterface("creator", HostedPrivateVirtualInterfaceArgs.builder()
 *             .connectionId("dxcon-zzzzzzzz")
 *             .ownerAccountId(accepterCallerIdentity.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId()))
 *             .vlan(4094)
 *             .addressFamily("ipv4")
 *             .bgpAsn(65352)
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(vpnGw)
 *                 .build());
 *         var accepterHostedPrivateVirtualInterfaceAccepter = new HostedPrivateVirtualInterfaceAccepter("accepterHostedPrivateVirtualInterfaceAccepter", HostedPrivateVirtualInterfaceAccepterArgs.builder()
 *             .virtualInterfaceId(creator.id())
 *             .vpnGatewayId(vpnGw.id())
 *             .tags(Map.of("Side", "Accepter"))
 *             .build(), CustomResourceOptions.builder()
 *                 .provider(aws.accepter())
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Direct Connect hosted private virtual interfaces using the VIF `id`. For example:
 * ```sh
 *  $ pulumi import aws:directconnect/hostedPrivateVirtualInterfaceAccepter:HostedPrivateVirtualInterfaceAccepter test dxvif-33cc44dd
 * ```
 * @property dxGatewayId The ID of the Direct Connect gateway to which to connect the virtual interface.
 * @property tags A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property virtualInterfaceId The ID of the Direct Connect virtual interface to accept.
 * @property vpnGatewayId The ID of the virtual private gateway to which to connect the virtual interface.
 */
public data class HostedPrivateVirtualInterfaceAccepterArgs(
    public val dxGatewayId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val virtualInterfaceId: Output<String>? = null,
    public val vpnGatewayId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.directconnect.HostedPrivateVirtualInterfaceAccepterArgs> {
    override fun toJava(): com.pulumi.aws.directconnect.HostedPrivateVirtualInterfaceAccepterArgs =
        com.pulumi.aws.directconnect.HostedPrivateVirtualInterfaceAccepterArgs.builder()
            .dxGatewayId(dxGatewayId?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .virtualInterfaceId(virtualInterfaceId?.applyValue({ args0 -> args0 }))
            .vpnGatewayId(vpnGatewayId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HostedPrivateVirtualInterfaceAccepterArgs].
 */
@PulumiTagMarker
public class HostedPrivateVirtualInterfaceAccepterArgsBuilder internal constructor() {
    private var dxGatewayId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var virtualInterfaceId: Output<String>? = null

    private var vpnGatewayId: Output<String>? = null

    /**
     * @param value The ID of the Direct Connect gateway to which to connect the virtual interface.
     */
    @JvmName("cpbqyslethasivhi")
    public suspend fun dxGatewayId(`value`: Output<String>) {
        this.dxGatewayId = value
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ihelsverudpmhiva")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The ID of the Direct Connect virtual interface to accept.
     */
    @JvmName("vbiqkymgnuogsgxu")
    public suspend fun virtualInterfaceId(`value`: Output<String>) {
        this.virtualInterfaceId = value
    }

    /**
     * @param value The ID of the virtual private gateway to which to connect the virtual interface.
     */
    @JvmName("mumtsgyujdhyqhum")
    public suspend fun vpnGatewayId(`value`: Output<String>) {
        this.vpnGatewayId = value
    }

    /**
     * @param value The ID of the Direct Connect gateway to which to connect the virtual interface.
     */
    @JvmName("oiwkippvlygcvhdj")
    public suspend fun dxGatewayId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dxGatewayId = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("rwaulmvrkpktpqbn")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("klbgxslbhsjuvdwn")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The ID of the Direct Connect virtual interface to accept.
     */
    @JvmName("ljqimmcvqdfteywu")
    public suspend fun virtualInterfaceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualInterfaceId = mapped
    }

    /**
     * @param value The ID of the virtual private gateway to which to connect the virtual interface.
     */
    @JvmName("sadjhdpoxukooceb")
    public suspend fun vpnGatewayId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpnGatewayId = mapped
    }

    internal fun build(): HostedPrivateVirtualInterfaceAccepterArgs =
        HostedPrivateVirtualInterfaceAccepterArgs(
            dxGatewayId = dxGatewayId,
            tags = tags,
            virtualInterfaceId = virtualInterfaceId,
            vpnGatewayId = vpnGatewayId,
        )
}
