@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.directconnect.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [HostedPublicVirtualInterface].
 */
@PulumiTagMarker
public class HostedPublicVirtualInterfaceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: HostedPublicVirtualInterfaceArgs = HostedPublicVirtualInterfaceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend HostedPublicVirtualInterfaceArgsBuilder.() -> Unit) {
        val builder = HostedPublicVirtualInterfaceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): HostedPublicVirtualInterface {
        val builtJavaResource =
            com.pulumi.aws.directconnect.HostedPublicVirtualInterface(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return HostedPublicVirtualInterface(builtJavaResource)
    }
}

/**
 * Provides a Direct Connect hosted public virtual interface resource. This resource represents the allocator's side of the hosted virtual interface.
 * A hosted virtual interface is a virtual interface that is owned by another AWS account.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.directconnect.HostedPublicVirtualInterface;
 * import com.pulumi.aws.directconnect.HostedPublicVirtualInterfaceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var foo = new HostedPublicVirtualInterface("foo", HostedPublicVirtualInterfaceArgs.builder()
 *             .addressFamily("ipv4")
 *             .amazonAddress("175.45.176.2/30")
 *             .bgpAsn(65352)
 *             .connectionId("dxcon-zzzzzzzz")
 *             .customerAddress("175.45.176.1/30")
 *             .routeFilterPrefixes(
 *                 "210.52.109.0/24",
 *                 "175.45.176.0/22")
 *             .vlan(4094)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Direct Connect hosted public virtual interfaces using the VIF `id`. For example:
 * ```sh
 *  $ pulumi import aws:directconnect/hostedPublicVirtualInterface:HostedPublicVirtualInterface test dxvif-33cc44dd
 * ```
 *
 */
public class HostedPublicVirtualInterface internal constructor(
    override val javaResource: com.pulumi.aws.directconnect.HostedPublicVirtualInterface,
) : KotlinCustomResource(javaResource, HostedPublicVirtualInterfaceMapper) {
    /**
     * The address family for the BGP peer. `ipv4 ` or `ipv6`.
     */
    public val addressFamily: Output<String>
        get() = javaResource.addressFamily().applyValue({ args0 -> args0 })

    /**
     * The IPv4 CIDR address to use to send traffic to Amazon. Required for IPv4 BGP peers.
     */
    public val amazonAddress: Output<String>
        get() = javaResource.amazonAddress().applyValue({ args0 -> args0 })

    public val amazonSideAsn: Output<String>
        get() = javaResource.amazonSideAsn().applyValue({ args0 -> args0 })

    /**
     * The ARN of the virtual interface.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The Direct Connect endpoint on which the virtual interface terminates.
     */
    public val awsDevice: Output<String>
        get() = javaResource.awsDevice().applyValue({ args0 -> args0 })

    /**
     * The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.
     */
    public val bgpAsn: Output<Int>
        get() = javaResource.bgpAsn().applyValue({ args0 -> args0 })

    /**
     * The authentication key for BGP configuration.
     */
    public val bgpAuthKey: Output<String>
        get() = javaResource.bgpAuthKey().applyValue({ args0 -> args0 })

    /**
     * The ID of the Direct Connect connection (or LAG) on which to create the virtual interface.
     */
    public val connectionId: Output<String>
        get() = javaResource.connectionId().applyValue({ args0 -> args0 })

    /**
     * The IPv4 CIDR destination address to which Amazon should send traffic. Required for IPv4 BGP peers.
     */
    public val customerAddress: Output<String>
        get() = javaResource.customerAddress().applyValue({ args0 -> args0 })

    /**
     * The name for the virtual interface.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The AWS account that will own the new virtual interface.
     */
    public val ownerAccountId: Output<String>
        get() = javaResource.ownerAccountId().applyValue({ args0 -> args0 })

    /**
     * A list of routes to be advertised to the AWS network in this region.
     */
    public val routeFilterPrefixes: Output<List<String>>
        get() = javaResource.routeFilterPrefixes().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The VLAN ID.
     */
    public val vlan: Output<Int>
        get() = javaResource.vlan().applyValue({ args0 -> args0 })
}

public object HostedPublicVirtualInterfaceMapper : ResourceMapper<HostedPublicVirtualInterface> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.directconnect.HostedPublicVirtualInterface::class == javaResource::class

    override fun map(javaResource: Resource): HostedPublicVirtualInterface =
        HostedPublicVirtualInterface(
            javaResource as
                com.pulumi.aws.directconnect.HostedPublicVirtualInterface,
        )
}

/**
 * @see [HostedPublicVirtualInterface].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [HostedPublicVirtualInterface].
 */
public suspend fun hostedPublicVirtualInterface(
    name: String,
    block: suspend HostedPublicVirtualInterfaceResourceBuilder.() -> Unit,
):
    HostedPublicVirtualInterface {
    val builder = HostedPublicVirtualInterfaceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [HostedPublicVirtualInterface].
 * @param name The _unique_ name of the resulting resource.
 */
public fun hostedPublicVirtualInterface(name: String): HostedPublicVirtualInterface {
    val builder = HostedPublicVirtualInterfaceResourceBuilder()
    builder.name(name)
    return builder.build()
}
