@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.directconnect.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [HostedPublicVirtualInterfaceAccepter].
 */
@PulumiTagMarker
public class HostedPublicVirtualInterfaceAccepterResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: HostedPublicVirtualInterfaceAccepterArgs =
        HostedPublicVirtualInterfaceAccepterArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend
    fun args(block: suspend HostedPublicVirtualInterfaceAccepterArgsBuilder.() -> Unit) {
        val builder = HostedPublicVirtualInterfaceAccepterArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): HostedPublicVirtualInterfaceAccepter {
        val builtJavaResource =
            com.pulumi.aws.directconnect.HostedPublicVirtualInterfaceAccepter(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return HostedPublicVirtualInterfaceAccepter(builtJavaResource)
    }
}

/**
 * Provides a resource to manage the accepter's side of a Direct Connect hosted public virtual interface.
 * This resource accepts ownership of a public virtual interface created by another AWS account.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.Provider;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
 * import com.pulumi.aws.directconnect.HostedPublicVirtualInterface;
 * import com.pulumi.aws.directconnect.HostedPublicVirtualInterfaceArgs;
 * import com.pulumi.aws.directconnect.HostedPublicVirtualInterfaceAccepter;
 * import com.pulumi.aws.directconnect.HostedPublicVirtualInterfaceAccepterArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var accepter = new Provider("accepter");
 *         final var accepterCallerIdentity = AwsFunctions.getCallerIdentity();
 *         var creator = new HostedPublicVirtualInterface("creator", HostedPublicVirtualInterfaceArgs.builder()
 *             .connectionId("dxcon-zzzzzzzz")
 *             .ownerAccountId(accepterCallerIdentity.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId()))
 *             .vlan(4094)
 *             .addressFamily("ipv4")
 *             .bgpAsn(65352)
 *             .customerAddress("175.45.176.1/30")
 *             .amazonAddress("175.45.176.2/30")
 *             .routeFilterPrefixes(
 *                 "210.52.109.0/24",
 *                 "175.45.176.0/22")
 *             .build());
 *         var accepterHostedPublicVirtualInterfaceAccepter = new HostedPublicVirtualInterfaceAccepter("accepterHostedPublicVirtualInterfaceAccepter", HostedPublicVirtualInterfaceAccepterArgs.builder()
 *             .virtualInterfaceId(creator.id())
 *             .tags(Map.of("Side", "Accepter"))
 *             .build(), CustomResourceOptions.builder()
 *                 .provider(aws.accepter())
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Direct Connect hosted public virtual interfaces using the VIF `id`. For example:
 * ```sh
 *  $ pulumi import aws:directconnect/hostedPublicVirtualInterfaceAccepter:HostedPublicVirtualInterfaceAccepter test dxvif-33cc44dd
 * ```
 *
 */
public class HostedPublicVirtualInterfaceAccepter internal constructor(
    override val javaResource: com.pulumi.aws.directconnect.HostedPublicVirtualInterfaceAccepter,
) : KotlinCustomResource(javaResource, HostedPublicVirtualInterfaceAccepterMapper) {
    /**
     * The ARN of the virtual interface.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The ID of the Direct Connect virtual interface to accept.
     */
    public val virtualInterfaceId: Output<String>
        get() = javaResource.virtualInterfaceId().applyValue({ args0 -> args0 })
}

public object HostedPublicVirtualInterfaceAccepterMapper :
    ResourceMapper<HostedPublicVirtualInterfaceAccepter> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.directconnect.HostedPublicVirtualInterfaceAccepter::class == javaResource::class

    override fun map(javaResource: Resource): HostedPublicVirtualInterfaceAccepter =
        HostedPublicVirtualInterfaceAccepter(
            javaResource as
                com.pulumi.aws.directconnect.HostedPublicVirtualInterfaceAccepter,
        )
}

/**
 * @see [HostedPublicVirtualInterfaceAccepter].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [HostedPublicVirtualInterfaceAccepter].
 */
public suspend fun hostedPublicVirtualInterfaceAccepter(
    name: String,
    block: suspend HostedPublicVirtualInterfaceAccepterResourceBuilder.() -> Unit,
):
    HostedPublicVirtualInterfaceAccepter {
    val builder = HostedPublicVirtualInterfaceAccepterResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [HostedPublicVirtualInterfaceAccepter].
 * @param name The _unique_ name of the resulting resource.
 */
public fun hostedPublicVirtualInterfaceAccepter(name: String):
    HostedPublicVirtualInterfaceAccepter {
    val builder = HostedPublicVirtualInterfaceAccepterResourceBuilder()
    builder.name(name)
    return builder.build()
}
